<?php

namespace Comitium5\DesignerBundle\Entity;

use Comitium5\DesignerBundle\Model\Interfaces\Layout\LayoutBreakpointInterface;
use Comitium5\DesignerBundle\Model\Traits\Breakpoint\BreakpointRelationTrait;
use Comitium5\DesignerBundle\Model\Traits\EnabledTrait;
use Comitium5\DesignerBundle\Model\Traits\Layout\LayoutRelationTrait;


/**
 * Class LayoutBreakpoint
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Entity
 */
class LayoutBreakpoint extends AbstractSerializeEntity implements LayoutBreakpointInterface
{
	use EnabledTrait,
		BreakpointRelationTrait,
		LayoutRelationTrait;

	/**
	 * @var int
	 */
	protected $columns;

	/**
	 * @return int
	 */
	public function getColumns()
	{
		return $this->columns;
	}

    /**
     * @param int $columns
     * @return self
     */
	public function setColumns(int $columns)
	{
		$this->columns = $columns;
		return $this;
	}

    /**
     * @access public
     * @param string[] $allowed optional
     * @param string[] $denied optional
     * @param string[] $entityFields optional
     * @return mixed[]
     */
    public function toArray($allowed = array(), $denied = array('layout'), $entityFields = array('breakpoint'))
    {
        return parent::toArray($allowed, $denied, $entityFields);
    }
}
