<?php

namespace Comitium5\DesignerBundle\Entity;

use Comitium5\DesignerBundle\Model\Interfaces\Layout\LayoutInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Layout\LayoutPageInterface;
use Comitium5\DesignerBundle\Model\Interfaces\Page\PageInterface;
use Comitium5\DesignerBundle\Model\Traits\DateTimeTrait;
use Comitium5\DesignerBundle\Model\Traits\HierarchicalTrait;
use Comitium5\DesignerBundle\Model\Traits\Layout\LayoutBreakpointCollectionTrait;
use Comitium5\DesignerBundle\Model\Traits\Layout\LayoutCollectionTrait;
use Comitium5\DesignerBundle\Model\Traits\Layout\LayoutPageCollectionTrait;
use Comitium5\DesignerBundle\Model\Traits\TmpIdentifierTrait;
use Comitium5\DesignerBundle\Model\Traits\View\ViewCollectionTrait;
use Doctrine\Common\Collections\ArrayCollection;


/**
 * Class Layout
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 * @package Comitium5\DesignerBundle\Entity
 */
class Layout extends AbstractSerializeEntity implements LayoutInterface
{
    use DateTimeTrait,
        HierarchicalTrait,
        LayoutBreakpointCollectionTrait,
        LayoutPageCollectionTrait,
        LayoutCollectionTrait,
        TmpIdentifierTrait,
        ViewCollectionTrait
        ;

    const FILE_FOLDER = 'Layouts';
    const FILE_NAME = 'layout%d.html.twig';

    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $class;

    /**
     * @var string
     */
    protected $color;

    /**
     * @var bool
     */
    protected $locked;

    /**
     * @var bool
     */
    protected $linked;

    /**
     * @var bool
     */
    protected $predefined;

    /**
     * @var string
     */
    protected $css;


    /**
     * Class constructor
     */
    public function __construct()
    {
        parent::__construct();
        $this->children = new ArrayCollection();
        $this->layoutBreakpoints = new ArrayCollection();
        $this->layoutPages = new ArrayCollection();
        $this->layouts = new ArrayCollection();
        $this->views = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return self
     */
    public function setName(string $name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getClass()
    {
        return $this->class;
    }

    /**
     * @param string $class
     * @return self
     */
    public function setClass(string $class)
    {
        $this->class = $class;
        return $this;
    }

    /**
     * @return string
     */
    public function getColor()
    {
        return $this->color;
    }

    /**
     * @param string $color
     * @return self
     */
    public function setColor(string $color)
    {
        $this->color = $color;
        return $this;
    }

    /**
     * @return bool
     */
    public function isLocked()
    {
        return $this->getLocked();
    }

    /**
     * @return bool
     */
    public function getLocked()
    {
        return $this->locked;
    }

    /**
     * @param bool $locked
     * @return self
     */
    public function setLocked($locked)
    {
        $this->locked = $locked;
        return $this;
    }

    /**
     * @return bool
     */
    public function isLinked()
    {
        return $this->getLinked();
    }

    /**
     * @return bool
     */
    public function getLinked()
    {
        return $this->linked;
    }

    /**
     * @param bool $linked
     * @return self
     */
    public function setLinked($linked)
    {
        $this->linked = $linked;
        return $this;
    }

    /**
     * @return bool
     */
    public function isPredefined()
    {
        return $this->getPredefined();
    }

    /**
     * @return bool
     */
    public function getPredefined()
    {
        return $this->predefined;
    }

    /**
     * @param bool $predefined
     * @return self
     */
    public function setPredefined($predefined)
    {
        $this->predefined = $predefined;
        return $this;
    }

    /**
     * @return string
     */
    public function getCss()
    {
        return $this->css;
    }

    /**
     * @param string $css
     * @return self
     */
    public function setCss($css)
    {
        $this->css = $css;
        return $this;
    }

    /**
     *
     * @param PageInterface|null $page
     *
     * @return LayoutPageInterface
     */
    public function getLayoutPage(PageInterface $page = null)
    {
    	return $this->layoutPages
            ->filter(
                function($layoutPage) use ($page) {
                    return ($layoutPage->getPage() == $page);
                }
            )->first();
    }

    /**
     *
     * @param PageInterface|null $page
     *
     * @return string
     */
    public function getHtml(PageInterface $page = null)
    {
        $html = '';

        $layoutPage = $this->getLayoutPage($page);

        if (!empty($layoutPage)) {
            $html = $layoutPage->getHtml();
        }

        return $html;
    }

    /**
     * @return string
     */
    public function getFilePath()
    {
        return self::FILE_FOLDER.DIRECTORY_SEPARATOR
        	.sprintf(
	            self::FILE_NAME, $this->getId()
	        );
    }

    /**
     * @access public
     * @param string[] $allowed optional
     * @param string[] $denied optional
     * @param string[] $entityFields optional
     * @return mixed[]
     */
    public function toArray($allowed = array(), $denied = array('parent'), $entityFields = array('children', 'layoutBreakpoints', 'layoutPages', 'layouts'))
    {
        return parent::toArray($allowed, $denied, $entityFields);
    }
}
