<?php

namespace Comitium5\DesignerBundle\Entity;

use Comitium5\DesignerBundle\Model\Interfaces\Breakpoint\BreakpointInterface;
use Comitium5\DesignerBundle\Model\Traits\DateTimeTrait;
use Comitium5\DesignerBundle\Model\Traits\EnabledTrait;
use Symfony\Component\Validator\Context\ExecutionContextInterface;

/**
 * Class Breakpoint.
 *
 * @author Tomàs Sayes <tomas@bab-soft.com>
 */
class Breakpoint extends AbstractSerializeEntity implements BreakpointInterface
{
    use EnabledTrait, DateTimeTrait;

    /**
     * @var string
     */
    protected $name;

    /**
     * @var int
     */
    protected $minWidth;

    /**
     * @var int
     */
    protected $maxWidth;

    /**
     * @var string
     */
    protected $type;

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     *
     * @return self
     */
    public function setName(string $name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return int
     */
    public function getMinWidth()
    {
        return $this->minWidth;
    }

    /**
     * @param int $width
     *
     * @return self
     */
    public function setMinWidth($width)
    {
        $this->minWidth = $width;

        return $this;
    }

    /**
     * @return int
     */
    public function getMaxWidth()
    {
        return $this->maxWidth;
    }

    /**
     * @param int $width
     *
     * @return self
     */
    public function setMaxWidth($width)
    {
        $this->maxWidth = $width;

        return $this;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param string $type
     *
     * @return self
     */
    public function setType(string $type)
    {
        $this->type = $type;

        return $this;
    }

    public function validateWidth(ExecutionContextInterface $context)
    {
        if (!$this->getMinWidth() && !$this->getMaxWidth()) {
            $context
                ->buildViolation('breakpoints.no_width')
                ->atPath('minWidth')
                ->addViolation();
        } else {
            if ($this->getMaxWidth() && ($this->getMinWidth() > $this->getMaxWidth())) {
                $context
                    ->buildViolation('breakpoints.min_higher_than_max')
                    ->atPath('minWidth')
                    ->addViolation();
            }
        }
    }
}
