<?php

namespace Comitium5\DesignerBundle\DataFixtures\ORM\Template;


use Comitium5\DesignerBundle\DataFixtures\Abstracts\AbstractFixture;
use Doctrine\Common\Persistence\ObjectManager;

/**
 * Class TemplateGroup.
 *
 * @author Oscar Jimenez <oscarjg19.developer@gmail.com>
 */
class TemplateGroupFixtures extends AbstractFixture
{
    /**
     * Load data fixtures with the passed EntityManager.
     *
     * @param ObjectManager $manager
     */
    public function load(ObjectManager $manager)
    {
        $factory = $this
            ->container
            ->get('designer.factory.template_group');

        foreach ($this->templateGroups() as $input) {
            $templateGroup = $factory->create();

            $templateGroup->setName($input['name']);
            $templateGroup->setDescription($input['description']);

            if ($input['parent'] !== null) {
                $templateGroup->setParent($this->getReference($input['parent']));
            }

            $this->setReference($input['reference'], $templateGroup);

            $manager->persist($templateGroup);
        }

        $manager->flush();
    }

    /**
     * @return array
     */
    private function templateGroups()
    {
        $templateGroups = [];

        if ($this->getEnvironment() === 'prod') {
            return $templateGroups;
        }

        for ($x = 0; $x <= 5; ++$x) {
            $faker = self::getFaker();

            switch ($x) {
                case 3:
                case 1:
                    $parent = 'template-group-0';
                    break;
                case 2:
                    $parent = 'template-group-1';
                    break;
                default:
                    $parent = null;
            }

            $templateGroups[] = [
                'name' => 'Template group '.($x + 1),
                'description' => $faker->realText(40),
                'parent' => $parent,
                'reference' => 'template-group-'.$x,
            ];
        }

        return $templateGroups;
    }
}
