<?php

namespace Comitium5\DesignerBundle\DataFixtures\ORM\Layout;

use Comitium5\DesignerBundle\DataFixtures\Abstracts\AbstractFixture;
use Comitium5\DesignerBundle\Entity\LayoutPage;
use Comitium5\DesignerBundle\Model\Interfaces\Layout\LayoutInterface;
use Doctrine\Common\Persistence\ObjectManager;

/**
 * Class LayoutFixtures
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\DataFixtures\ORM\Layout
 */
class LayoutFixtures extends AbstractFixture
{
    /**
     * @param ObjectManager $manager
     */
    public function load(ObjectManager $manager)
    {
        $factory = $this
            ->container
            ->get("designer.factory.layout");

        foreach ($this->layouts() as $layout) {
            /**
             * @var LayoutInterface $layout
             */
            $layoutEntity = $factory->create();

            $layoutEntity
                ->setName($layout["name"])
                ->setLocked($layout["locked"])
                ->setLinked($layout["linked"])
                ->setPredefined($layout["predefined"])
                ;

            foreach ($layout["layoutPages"] as $layoutPage) {
                $layoutPageEntity = new LayoutPage();

                $layoutPageEntity
                    ->setPosition($layoutPage["position"])
                    ->setHtml($layoutPage["html"]);

                $layoutEntity->addLayoutPage($layoutPageEntity);
            }

            $this->setReference($layout["reference"], $layoutEntity);

            $manager->persist($layoutEntity);
        }

        $manager->flush();
    }

    /**
     * @return array[]
     */
    private function layouts(): array
    {
        return [
            [
                "name" => "Header",
                "reference" => "layout-header",
                "locked" => false,
                "linked" => true,
                "predefined" => true,
                "layoutPages" => [
                    [
                        "position" => 1,
                        "html" => '<div class="csl-inner csl-hot"></div>',
                    ],
                ],
            ],
            [
                "name" => "Footer",
                "reference" => "layout-footer",
                "locked" => false,
                "linked" => true,
                "predefined" => true,
                "layoutPages" => [
                    [
                        "position" => 3,
                        "html" => '<div class="csl-inner csl-hot"></div>',
                    ],
                ],
            ],
            [
                "name" => "Home",
                "reference" => "layout-home",
                "locked" => false,
                "linked" => false,
                "predefined" => false,
                "layoutPages" => [
                    [
                        "position" => 2,
                        "html" => '<div class="csl-inner"></div>',
                    ],
                ],
            ],
            [
                "name" => "Thematic left",
                "reference" => "layout-thematic-left",
                "locked" => false,
                "linked" => false,
                "predefined" => false,
                "layoutPages" => [
                    [
                        "position" => 2,
                        "html" => '<div class="csl-inner"></div>',
                    ],
                ],
            ],
            [
                "name" => "Thematic right",
                "reference" => "layout-thematic-right",
                "locked" => false,
                "linked" => true,
                "predefined" => false,
                "layoutPages" => [
                    [
                        "position" => 2,
                        "html" => '<div class="csl-inner"></div>',
                    ],
                ],
            ],
            [
                "name" => "Article top",
                "reference" => "layout-article-top",
                "locked" => false,
                "linked" => false,
                "predefined" => false,
                "layoutPages" => [
                    [
                        "position" => 2,
                        "html" => '<div class="csl-inner"></div>',
                    ],
                ],
            ],
            [
                "name" => "Article left",
                "reference" => "layout-article-left",
                "locked" => false,
                "linked" => false,
                "predefined" => false,
                "layoutPages" => [
                    [
                        "position" => 2,
                        "html" => '<div class="csl-inner"></div>',
                    ],
                ],
            ],
            [
                "name" => "Article right",
                "reference" => "layout-article-right",
                "locked" => false,
                "linked" => true,
                "predefined" => false,
                "layoutPages" => [
                    [
                        "position" => 2,
                        "html" => '<div class="csl-inner"></div>',
                    ],
                ],
            ],
            [
                "name" => "Live top",
                "reference" => "layout-live-top",
                "locked" => false,
                "linked" => false,
                "predefined" => false,
                "layoutPages" => [
                    [
                        "position" => 1,
                        "html" => '<div class="csl-inner"></div>',
                    ],
                ],
            ],
            [
                "name" => "Live left",
                "reference" => "layout-live-left",
                "locked" => false,
                "linked" => false,
                "predefined" => false,
                "layoutPages" => [
                    [
                        "position" => 1,
                        "html" => '<div class="csl-inner"></div>',
                    ],
                ],
            ],
            [
                "name" => "Live right",
                "reference" => "layout-live-right",
                "locked" => false,
                "linked" => true,
                "predefined" => false,
                "layoutPages" => [
                    [
                        "position" => 1,
                        "html" => '<div class="csl-inner"></div>',
                    ],
                ],
            ],
            [
                "name" => "Static",
                "reference" => "layout-static",
                "locked" => false,
                "linked" => false,
                "predefined" => false,
                "layoutPages" => [
                    [
                        "position" => 2,
                        "html" => '<div class="csl-inner"></div>',
                    ],
                ],
            ],
            [
                "name" => "AMP",
                "reference" => "layout-amp",
                "locked" => false,
                "linked" => false,
                "predefined" => false,
                "layoutPages" => [
                    [
                        "position" => 1,
                        "html" => '<div class="csl-inner"></div>',
                    ],
                ],
            ],
            [
                "name" => "AMP news list",
                "reference" => "layout-amp-news-list",
                "locked" => false,
                "linked" => false,
                "predefined" => false,
                "layoutPages" => [
                    [
                        "position" => 1,
                        "html" => '<div class="csl-inner"></div>',
                    ],
                ],
            ],
            [
                "name" => "Newsletter",
                "reference" => "layout-newsletter",
                "locked" => false,
                "linked" => false,
                "predefined" => false,
                "layoutPages" => [
                    [
                        "position" => 1,
                        "html" => '<div class="csl-inner"></div>',
                    ],
                ],
            ],
            [
                "name" => "Search",
                "reference" => "layout-search",
                "locked" => false,
                "linked" => false,
                "predefined" => false,
                "layoutPages" => [
                    [
                        "position" => 2,
                        "html" => '<div class="csl-inner"></div>',
                    ],
                ],
            ],
            [
                "name" => "Breadcrumb",
                "reference" => "layout-breadcrumb",
                "locked" => false,
                "linked" => true,
                "predefined" => false,
                "layoutPages" => [
                    [
                        "position" => 1,
                        "html" => '<div class="csl-inner"></div>',
                    ],
                ],
            ],
            [
                "name" => "Gallery",
                "reference" => "layout-gallery",
                "locked" => false,
                "linked" => false,
                "predefined" => false,
                "layoutPages" => [
                    [
                        "position" => 1,
                        "html" => '<div class="csl-inner"></div>',
                    ],
                ],
            ],
            [
                "name" => "Account",
                "reference" => "layout-account",
                "locked" => false,
                "linked" => false,
                "predefined" => false,
                "layoutPages" => [
                    [
                        "position" => 1,
                        "html" => '<div class="csl-inner"></div>',
                    ],
                ],
            ],
            [
                "name" => "Error",
                "reference" => "layout-error",
                "locked" => false,
                "linked" => false,
                "predefined" => false,
                "layoutPages" => [
                    [
                        "position" => 1,
                        "html" => '<div class="csl-inner"></div>',
                    ],
                ],
            ],
        ];
    }
}
