<?php

namespace Comitium5\DesignerBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;


/**
 * Class CommonConfigController
 *
 * @author Fernando Pradas <fernando@bab-soft.com>
 * @package ComitiumSuite\Bundle\CSCoreBundle\Controller
 */
class CommonConfigController extends Controller
{
    /**
     * @return Response
     */
    public function renderCKEditorConfigAction()
    {
        $config = $this->container->getParameter('ckeditor');

        return $this->render('Comitium5DesignerBundle:Common:ckeditor.html.twig', array(
            'config' => $config
        ));
    }

    /**
     * @param Request $request
     * @return Response|static
     */
    public function getCKEditorConfigAction(Request $request)
    {
        $config = $this
            ->get("designer.resolver.ckeditor")
            ->resolve($request->get("config", []));

        return JsonResponse::create($config);
    }
}
