<?php

namespace Comitium5\DesignerBundle\Builder\Api;

use Comitium5\ApiClientBundle\Client\ClientInterface;

/**
 * Class ClientFromLocaleBuilder
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\DesignerBundle\Builder\Api
 */
class ClientFromLocaleBuilder
{
    /**
     * @var ClientInterface
     */
    protected $apiClient;

    /**
     * @var string
     */
    protected $site;

    /**
     * @var string
     */
    protected $subsite;

    /**
     * ApiClientBuilder constructor.
     *
     * @param ClientInterface $apiClient
     * @param string $site
     * @param string $subsite
     */
    public function __construct(
        ClientInterface $apiClient,
        string $site,
        string $subsite
    ) {
        $this->apiClient = $apiClient;
        $this->site      = $site;
        $this->subsite   = $subsite;
    }

    /**
     * @param string $localeCode
     *
     * @return ClientInterface
     */
    public function __invoke(string $localeCode): ClientInterface
    {
        return $this
            ->apiClient
            ->buildClient(
                $this->site,
                $this->subsite,
                $localeCode
            );
    }
}
