<?php

namespace Comitium5\CommonWidgetsBundle\Controller;

use Comitium5\ApiClientBundle\Client\Client;
use Comitium5\CommonWidgetsBundle\Normalizers\Poll\PollRedisPushService;
use Comitium5\CommonWidgetsBundle\Services\Poll\PollService;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class PollController
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\CommonWidgetsBundle\Controller
 */
class PollController extends AbstractController
{
    /**
     * @param Request $request
     * @param $id
     *
     * @return JsonResponse
     */
    public function fetchAction(Request $request, $id)
    {
        try {
            $sitePrefix     = $request->get("sitePrefix", null);
            $subsiteAcronym = $request->get("subsiteAcronym", null);
            $localeCode     = $request->get("locale", null);

            $pollHandler = new PollService($this->buildApi($sitePrefix, $subsiteAcronym, $localeCode), $id);

            return $pollHandler->resolvePoll();
        } catch (\Exception $exception) {
            return new JsonResponse($exception->getMessage(), Response::HTTP_BAD_REQUEST);
        }
    }

    /**
     * @param Request $request
     * @param $id
     *
     * @return JsonResponse
     * @throws \Exception
     */
    public function voteAction(Request $request, $id)
    {
        $answerId = $request->get('answerId');

        if (!is_numeric($id) || !is_numeric($answerId)) {
            return $this->resolveVoteResponse(false);
        }

        $pollPushService = new PollRedisPushService(
            $this->get("comitium5_common_widgets.cache.redis")->getClient(),
            $request,
            $answerId,
            $id
        );

        $success = $pollPushService->pushIntoRedis();

        return $this->resolveVoteResponse($success);
    }

    /**
     * @param $sitePrefix
     * @param $subsiteAcronym
     * @param $localeCode
     *
     * @return Client
     */
    private function buildApi($sitePrefix, $subsiteAcronym, $localeCode)
    {
        return $this
            ->get("comitium5_api_client.client_v2")
            ->buildClient(
                $sitePrefix,
                $subsiteAcronym,
                $localeCode
            );
    }

    /**
     * @param $success
     *
     * @return JsonResponse
     */
    private function resolveVoteResponse($success)
    {
        return JsonResponse::create(
            [
                'status' => $success ? 'OK' : 'Error processing poll result',
            ],
            $success ? JsonResponse::HTTP_OK : JsonResponse::HTTP_BAD_REQUEST
        );
    }
}
