<?php

namespace Comitium5\CommonWidgetsBundle\Utils\RichSnippets;

use Comitium5\CommonWidgetsBundle\Utils\Common\CommonUtils;

/**
 * Class ArticleRichSnippets
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\Utils\RichSnipets
 */
class ArticleRichSnippets implements GoogleSnippetsInterface
{
    /**
     * @var int
     */
    public static $maxTitleLength = 110;

    /**
     * @var string
     */
    public static $defaultCompleteText = "...";

    /**
     * DefaultValues[
     *  defaultLogoUrl,
     *  defaultLogoWidth,
     *  defaultLogoHeight,
     *  imageResize,
     *  authorName,
     *  publisherName,
     * ]
     *
     *
     * @param array $entity
     * @param array $defaultValues
     *
     * @return array
     */
    public static function googleRichSnippet(array $entity, array $defaultValues = [])
    {
        $canonical = CommonUtils::resolveMetaDataSimpleValue($entity, "canonical", strval($entity["permalink"]));

        $title = rtrim($entity['lang']['title']);

        if (mb_strlen($title) > self::$maxTitleLength) {
            $title = rtrim(mb_substr($title, 0, (self::$maxTitleLength - mb_strlen(self::$defaultCompleteText)))) . self::$defaultCompleteText;
        }

        $logo = [
            '@type' => self::IMAGE_OBJECT_LABEL,
            'url' => !empty($defaultValues["defaultLogoUrl"]) ? $defaultValues["defaultLogoUrl"] : "",
            'width' => !empty($defaultValues["defaultLogoWidth"]) ? $defaultValues["defaultLogoWidth"] : "",
            'height' => !empty($defaultValues["defaultLogoHeight"]) ? $defaultValues["defaultLogoHeight"] : "",
        ];

        $publishedAtDate = CommonUtils::instanceDateTimeFromArray($entity['publishedAt']);

        $updatedAtDate = $entity['updatedAt'];

        if (empty($updatedAtDate)) {
            $updatedAtDate = $publishedAtDate;
        } else {
            $updatedAtDate = CommonUtils::instanceDateTimeFromArray($entity['updatedAt']);
        }

        $image = $logo;

        if (!empty($entity["lang"]["fieldValues"])) {
            $images = CommonUtils::getFieldsByType($entity["lang"]["fieldValues"], "image");

            if (!empty($images)) {

                if (!empty($images[0]["value"])) {
                    $imageEntity = $images[0]["value"];

                    if (!empty($defaultValues["imageResize"])) {
                        $imageEntity = CommonUtils::getAssetResize($imageEntity, $defaultValues["imageResize"]);
                    }

                    $image = [
                        '@type' => self::IMAGE_OBJECT_LABEL,
                        'url' => $imageEntity['url'],
                        'width' => $imageEntity['metadata']['width'],
                        'height' => $imageEntity['metadata']['height'],
                    ];
                }
            }
        }

        if (!empty($defaultValues["authorName"])) {
            $authorName = $defaultValues["authorName"];
        } elseif (!empty($entity["author"])) {
            $authorName = $entity["author"]["name"];

            if (!empty($entity["author"]["surname"])) {
                $authorName .= " " . $entity["author"]["surname"];
            }
        } else {
            $authorName = "";
        }

        $author = [
            '@type' => self::PERSON_LABEL,
            "name" => $authorName,
        ];

        if (!empty($entity['author']['permalink'])) {
            $author['url'] = $entity['author']['permalink'];
        }

        $json = [
            '@context' => self::SCHEMA_ORG_URL,
            '@type' => self::GOOGlE_ARTICLE_TYPE,
            'mainEntityOfPage' => [
                '@type' => self::WEB_PAGE_LABEL,
                '@id' => $canonical,
            ],
            'headline' => $title,
            'image' => $image,
            'datePublished' => $publishedAtDate instanceof \DateTime ? $publishedAtDate->format(\DateTime::ISO8601) : "",
            'dateModified' => $updatedAtDate instanceof \DateTime ? $updatedAtDate->format(\DateTime::ISO8601) : "",
            'author' => $author,
            'publisher' => [
                '@type' => self::ORGANIZATION_LABEL,
                'name' => !empty($defaultValues["publisherName"]) ? $defaultValues["publisherName"] : "",
                'logo' => $logo,
            ],
        ];

        if (!empty($defaultValues["description"])) {
            $json['description'] = $defaultValues["description"];
        } else {
            if (!empty($entity["lang"]["fieldValues"])) {
                $body = CommonUtils::getFieldsByType($entity["lang"]["fieldValues"], 'body');

                if (!empty($body[0]["value"])) {
                    $body = $body[0]["value"];
                    $json['description'] = strip_tags($body);
                }
            }
        }

        return $json;
    }
}