<?php

namespace Comitium5\CommonWidgetsBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class PaginateController
 *
 * @author Oscar Jimenez <oscarjg19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\Controller
 */
class PaginateController extends AbstractController
{
    /**
     * Function to call your paginate method of your WidgetController class.
     * Your method should return the html used by the paginate.
     */
    public function paginateAction()
    {
        try {
            $request = $this->get('request_stack')->getMasterRequest();

            $page = $request->get('page', null);
            $controllerNamespace = $request->get('controller', null);
            $action = $request->get('action', null);

            $controller = $this->buildControllerInstance($controllerNamespace, $action);
            $parameters = $this->buildParameters($request->get('parameters'));

            if ($page !== null && isset($parameters['page'])) {
                $parameters['page'] = $page;
            }

            return $controller->$action($parameters);
        } catch (\Throwable $e) {
            return new Response($e->getMessage(), Response::HTTP_BAD_REQUEST);
        }
    }
}
