<?php

namespace Comitium5\CommonWidgetsBundle\Services\Security;

use Symfony\Component\Security\Core\User\EquatableInterface;
use Symfony\Component\Security\Core\User\UserInterface;

/**
 * Class ComitiumUser
 *
 * @author Óscar Jimenez <oscar@bab-soft.com>
 * @package Comitium5\CommonWidgetsBundle\Services\Security
 */
class ComitiumUser implements UserInterface, EquatableInterface
{
    /**
     * @var integer
     */
    protected $id;

    /**
     * @var string
     */
    protected $nick;

    /**
     * @var string
     */
    protected $password;

    /**
     * @var string
     */
    protected $firstName;

    /**
     * @var string
     */
    protected $middleName;

    /**
     * @var string
     */
    protected $lastName;

    /**
     * @var string
     */
    protected $email;

    /**
     * @var array
     */
    protected $socialNetworkContacts;

    /**
     * @var string
     */
    protected $salt;

    /**
     * @var array
     */
    protected $roles = array("CS-USER");

    /**
     * @var array
     */
    protected $subscriptions;

    /**
     * @var array
     */
    protected $cookies;

    /**
     * @var array
     */
    protected $contactGroups;

    /**
     * @var array
     */
    protected $userData;

    /**
     * ComitiumUser constructor.
     * @param array $userData
     * @param array $roles
     */
    public function __construct(array $userData = [], array $roles = [])
    {
        $this->subscriptions = [];

        if (!empty($roles)) {
            $this->roles = $roles;
        }

        $this->setFromUserData($userData);
    }

    /**
     * @param $userData
     * @return $this
     */
    public function setFromUserData($userData)
    {
        foreach ($userData as $property => $data) {
            if (property_exists($this, $property)) {
                $this->{$property} = $data;
            }
        }

        $this->userData = $userData;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getRoles()
    {
        return $this->roles;
    }

    /**
     * @return mixed
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @return mixed
     */
    public function getSalt()
    {
        return $this->salt;
    }

    /**
     * @return mixed
     */
    public function getUsername()
    {
        return $this->nick;
    }

    /**
     *
     */
    public function eraseCredentials()
    {
        // TODO: Implement eraseCredentials() method.
    }

    /**
     * @param UserInterface $user
     * @return bool
     */
    public function isEqualTo(UserInterface $user)
    {
        if (!$user instanceof ComitiumUser) {
            return false;
        }

        return true;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * @return string
     */
    public function getMiddleName()
    {
        return $this->middleName;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @return array
     */
    public function getSocialNetworkContacts()
    {
        return $this->socialNetworkContacts;
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getNick()
    {
        return $this->nick;
    }

    /**
     * @return array
     */
    public function getSubscriptions()
    {
        return $this->subscriptions;
    }

    /**
     * @return array
     */
    public function getCookies()
    {
        return $this->cookies;
    }

    /**
     * @param array $cookies
     *
     * @return ComitiumUser
     */
    public function setCookies(array $cookies)
    {
        $this->cookies = $cookies;

        return $this;
    }

    /**
     * @return array
     */
    public function getContactGroups()
    {
        return $this->contactGroups;
    }

    /**
     * @return array
     */
    public function getUserData()
    {
        return $this->userData;
    }
}
