<?php

namespace Comitium5\CommonWidgetsBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/extension.html#cookbook-bundles-extension-config-class}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();

        $rootNode = $treeBuilder->root('comitium5_common_widgets');

        $rootNode->children()
            ->scalarNode('asset_url_prefix')->isRequired()->end()
            ->scalarNode('asset_use_cdn')->defaultValue(false)->end()
            ->scalarNode('cdn')->defaultValue([])->end()
            ->variableNode('redis_host')->isRequired()->end()
            ->variableNode('redis_scheme')->isRequired()->end()
            ->variableNode('redis_port')->isRequired()->end()
            ->variableNode('redis_database')->isRequired()->end()
            ->variableNode('redis_password')->defaultValue(null)->end()
            ->arrayNode('elastic_server')
                ->children()
                    ->scalarNode('host')->defaultValue('%elastic_ip%')->end()
                    ->scalarNode('port')->defaultValue('%elastic_port%')->end()
                    ->scalarNode('username')->defaultNull()->end()
                    ->scalarNode('password')->defaultNull()->end()
                    ->scalarNode('transport')->defaultNull()->end()
                    ->scalarNode('curl')->defaultNull()->end()
                ->end()
            ->end()
            ->scalarNode('recaptcha_site_key')->isRequired()->end()
            ->scalarNode('recaptcha_secret')->isRequired()->end()
            ->scalarNode('is_prod_environment')->isRequired()->end()
            ->scalarNode('google_api_key')->isRequired()->end()
            ->variableNode('mailing_stats_redis_host')->isRequired()->end()
            ->variableNode('mailing_stats_redis_scheme')->isRequired()->end()
            ->variableNode('mailing_stats_redis_port')->isRequired()->end()
            ->variableNode('mailing_stats_redis_database')->isRequired()->end()
            ->variableNode('mailing_stats_redis_password')->defaultValue(null)->end()
            ->scalarNode('subsite_config_path')->isRequired()->end()
            ->end();

        return $treeBuilder;
    }
}
