<?php

namespace Comitium5\CommonWidgetsBundle\Tests\Services;

use Comitium5\CommonWidgetsBundle\Services\SubSiteConfigLoader;
use Comitium5\CommonWidgetsBundle\Tests\Stubs\WidgetControllerStub;
use Comitium5\CommonWidgetsBundle\Tests\TestCase;

/**
 * Class SubSiteConfigLoaderTest
 *
 * @author Óscar Jimenez <oscar@bab-soft.com>
 * @package Comitium5\CommonWidgetsBundle\Tests\Services
 *
 * phpunit Tests/Services/SubSiteConfigLoaderTest.php
 */
class SubSiteConfigLoaderTest extends TestCase
{
    /**
     * @throws \Exception
     */
    public function testGetValue()
    {
        $path = __DIR__ . '/../Stubs/Data/Constants';

        SubSiteConfigLoader::setConfigFilePath($path);

        $controller = new WidgetControllerStub();
        $controller->renderAction([
            '_subsite' => [
                'id'      => 1,
                'acronym' => 'foo'
            ]
        ]);

        $this->assertEquals(SubSiteConfigLoader::getValue('project.subsite_name'), 'foo');

        $controller->renderAction([
            '_subsite' => [
                'id'      => 1,
                'acronym' => 'no-exists'
            ]
        ]);

        $this->assertEquals(SubSiteConfigLoader::getValue('project.subsite_name'), 'default');

        $controller->renderAction([
            '_subsite' => [
                'id'      => 1,
                'acronym' => 'bar'
            ]
        ]);

        $this->assertEquals(SubSiteConfigLoader::getValue('project.subsite_name'), 'bar');
    }
}
