<?php

namespace Comitium5\CommonWidgetsBundle\Services\Mailer;

use Comitium5\CommonWidgetsBundle\ValueObject\Mailer\SwiftMailerTemplating;

/**
 * Class MailerService
 * @package Comitium5\CommonWidgetsBundle\Services
 */
class SwiftMailerTemplatingService
{
    /**
     * @var SwiftMailerTemplating
     */
    protected $mailerValueObject;

    /**
     * SwiftMailerTemplatingService constructor.
     * @param SwiftMailerTemplating $mailerValueObject
     */
    public function __construct(SwiftMailerTemplating $mailerValueObject)
    {
        $this->mailerValueObject = $mailerValueObject;
    }

    /**
     * @param $template
     * @param array $data
     * @return int
     */
    public function sendMail(
        $template,
        array $data
    ) {

        $data = array_merge(
            $data,
            ['locale' => $this->mailerValueObject->getLocale()]
        );

        $content = $this
            ->renderContent(
                $template,
                $data
        );

        $message = $this->createMessageInstance($content);

        return $this->send($message);
    }

    /**
     * @param $template
     * @param $data
     * @return string
     */
    protected function renderContent($template, $data)
    {
        return $this
            ->mailerValueObject
            ->getTemplating()
            ->render(
                $template,
                $data
            );
    }

    /**
     * @param $content
     * @return $this
     */
    protected function createMessageInstance($content)
    {
        $message = \Swift_Message::newInstance();

        $message
            ->setSubject($this->mailerValueObject->getSubject())
            ->setTo($this->mailerValueObject->getTo())
            ->setFrom($this->mailerValueObject->getFrom(), $this->mailerValueObject->getFromName())
            ->setBody($content, 'text/html')
            ->setBcc($this->mailerValueObject->getBcc())
        ;

        return $message;
    }

    /**
     * @param \Swift_Message $message
     * @return int
     */
    protected function send(\Swift_Message $message)
    {
        return $this
            ->mailerValueObject
            ->getMailer()
            ->send($message);
    }
}