Comitium Suite ElasticSearch provider
========================

## Use example:
``` php
    var provider = $this->get("comitium5_common_widgets.elastic_search_minimal_provider");
    
    $matchBooleanSearch = new BoolQuery();
     
    $matchLocale = new Match();
    $matchLocale->setFieldQuery("locale", "ca");
     
    $matchSubSite = new Match();
    $matchSubSite->setFieldQuery("subSite.id", 1);
     
    $matchSearchable = new Match();
    $matchSearchable->setFieldQuery("searchable", true);
     
    $match = new Match();
    $match->setFieldQuery("title", "foo");
    $match->setFieldBoost("title", 10);
    $match->setFieldAnalyzer("title", "standard_analyzer");
    $matchBooleanSearch->addMust($match);
     
    $match = new Match();
    $match->setFieldQuery("fields.boolean_sense_lactosa.values", 1);
    $match->setFieldBoost("fields.boolean_sense_lactosa.values", 2);
    $match->setFieldAnalyzer("fields.boolean_sense_lactosa.values", "standard_analyzer");
    $matchBooleanSearch->addMust($match);
     
    $match = new Match();
    $match->setFieldQuery("fields.entity_autor.values", 9687);
    $match->setFieldBoost("fields.entity_autor.values", 2);
    $match->setFieldAnalyzer("fields.entity_autor.values", "standard_analyzer");
    $matchBooleanSearch->addMust($match);
     
    $match = new Match();
    $match->setFieldQuery("fields.boolean_vegetariana.values", 1);
    $match->setFieldBoost("fields.boolean_vegetariana.values", 2);
    $match->setFieldAnalyzer("fields.boolean_vegetariana.values", "standard_analyzer");
    $matchBooleanSearch->addMust($match);
     
    $boolQuery = new BoolQuery();
    $boolQuery->addMust($matchLocale);
    $boolQuery->addMust($matchSubSite);
    $boolQuery->addMust($matchSearchable);
    $boolQuery->addMust($matchBooleanSearch);
     
    $query = Query::create($boolQuery);
    
    $results = $provider
        ->search(
            $query,
            ["limit" => 10],
            "MY_INDEX", #cuina
            "MY_TYPE" #articles
        );
    
```
