<?php

namespace Comitium5\CommonWidgetsBundle\Utils\Common\Checker;

use Symfony\Component\DomCrawler\Crawler;

/**
 * Class HtmlVideoChecker
 * @package Comitium5\CommonWidgetsBundle\Utils\Common
 */
class HtmlVideoChecker
{
    /**
     * Check if there are any video string on text passed as first argument
     * @param string $body
     * @param array $keyWords
     * @return bool
     */
    public static function check($body, array $keyWords = [])
    {
        $keyWords = empty($keyWords) ?
            self::defaultKeyWords():
            $keyWords
        ;

        $hasVideo = false;

        foreach ($keyWords as $keyword) {
            if ($keyword['checker'] === 'crawler') {
                $hasVideo = self::getByCrawler($body, $keyword['keyword']);
            } elseif ($keyword['checker'] === 'search') {
                $hasVideo = self::getBySearch($body, $keyword['keyword']);
            }

            if ($hasVideo === true) {
                break;
            }
        }

        return $hasVideo;
    }

    /**
     * HtmlVideoCheckerService constructor
     */
    public static function defaultKeyWords()
    {
        return [
            'twitter'    => ['checker' => 'crawler', 'keyword' => '.twitter-video'],
            'youtube'    => ['checker' => 'search', 'keyword' => 'youtube.com/embed'],
            'vimeo'      => ['checker' => 'search', 'keyword' => 'player.vimeo.com'],
            'html5video' => ['checker' => 'crawler', 'keyword' => 'video'],
            'digiteka'   => ['checker' => 'search', 'keyword' => 'www.ultimedia.com']
        ];
    }

    /**
     * @param $body
     * @param $keyword
     * @return bool
     */
    protected static function getByCrawler($body, $keyword)
    {
        try {
            $crawler     = new Crawler($body);
            $elements    = $crawler->filter($keyword);
            $numElements = $elements->count();
        } catch (\Throwable $e) {
            $numElements = 0;
        }

        return $numElements > 0;
    }

    /**
     * @param $body
     * @param $keyword
     * @return bool
     */
    protected static function getBySearch($body, $keyword)
    {
        return mb_strpos($body, $keyword) !== false;
    }
}
