<?php

namespace Comitium5\CommonWidgetsBundle\Tests\Services\Poll;

use Comitium5\CommonWidgetsBundle\Normalizers\Poll\PollRedisPushService;
use Comitium5\CommonWidgetsBundle\Tests\TestCase;
use Predis\Client;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class PollRedisPushServiceTest
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\CommonWidgetsBundle\Tests\Services\Poll
 */
class PollRedisPushServiceTest extends TestCase
{
    /**
     * @throws \Exception
     */
    public function testPushIntoRedis()
    {
        $service = new PollRedisPushService(
            $this->redisClient(),
            $this->request(),
            1,
            2
        );

        $this->assertTrue($service->pushIntoRedis());

        $service = new PollRedisPushService(
            $this->redisClient(false),
            $this->request(),
            1,
            2
        );

        $this->assertFalse($service->pushIntoRedis());
    }

    /**
     * @param bool $result
     *
     * @return \PHPUnit_Framework_MockObject_MockObject
     */
    private function redisClient($result = true)
    {
        $mock = $this->createPartialMock(Client::class, ["lpush"]);

        if ($result) {
            $mock
                ->method("lpush")
                ->willReturn(true);
        } else {
            $mock
                ->method("lpush")
                ->willThrowException(new \Exception());
        }

        return $mock;
    }

    /**
     * @param string $ip
     *
     * @return \PHPUnit_Framework_MockObject_MockObject
     */
    private function request($ip = "127.0.0.1")
    {
        $builder = $this->getMockBuilder(Request::class);

        $request = $builder
            ->setMethods(['getClientIp'])
            ->getMock();

        $request
            ->method('getClientIp')
            ->willReturn($ip);

        return $request;
    }
}
