<?php

namespace Comitium5\CommonWidgetsBundle\Tests\RichSnippets;

use Comitium5\CommonWidgetsBundle\Tests\TestCase;
use Comitium5\CommonWidgetsBundle\Utils\RichSnippets\ActivityRichSnippets;

/**
 * Class ActivityRichSnippetsTest
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\Tests\Search
 */
class ActivityRichSnippetsTest extends TestCase
{
    /**
     * @param $activity
     *
     * @throws \Exception
     *
     * @dataProvider activities
     * phpunit Tests/RichSnippets/ActivityRichSnippetsTest.php
     */
    public function testGoogleRichSnippet($activity)
    {
        $data = ActivityRichSnippets::googleRichSnippet($activity);

        $id = $activity["id"];

        if ($id === 1) {
            $startDate = (new \DateTime())->format(\DateTime::ISO8601);
            $endDate   = (new \DateTime("NOW + 1 YEAR"))->format(\DateTime::ISO8601);
        } else {
            $startDate = "2016-06-10T00:00:00+0200";
            $endDate   = "2016-06-18T00:00:00+0200";
        }

        $json = [
            "@context"    => ActivityRichSnippets::SCHEMA_ORG_URL,
            "@type"       => ActivityRichSnippets::GOOGlE_ACTIVITY_TYPE,
            "name"        => "foo",
            "description" => "bar",
            "startDate"   => $startDate,
            "endDate"     => $endDate,
            "url"         => "http://foo.bar",
            "location"    =>  [
                "@type"   => ActivityRichSnippets::LOCATION_TYPE,
                "name"    => "Foo location",
                "address" => "C/Foo 10"
            ],
            "offers" => [
                "url"   => "http://foo.bar",
                "name"  => "foo",
                "price" => 0,
            ],
        ];

        if ($id === 2) {
            $json["image"] = [
                '@type'  => ActivityRichSnippets::IMAGE_OBJECT_LABEL,
                'url'    => "http://www.asset.foo",
                'width'  => 100,
                'height' => 100,
            ];

            $json["performer"] = "Foo organizer";
        }

        $this->assertEquals($data, $json);
    }

    public function activities()
    {
        return [
             [
                [
                    "id" => 1,
                    "lang" => [
                        "title" => "foo",
                        "description" => "bar"
                    ],
                    "permalink" => "http://foo.bar",
                    "mapLocations" => [
                        [
                            "title"   => "Foo location",
                            "address" => "C/Foo 10",
                        ],
                        [
                            "title"   => "Bar location",
                            "address" => "C/Bar 10",
                        ],
                    ]
                ],
            ],
            [
                [
                    "id" => 2,
                    "lang" => [
                        "title" => "foo",
                        "description" => "bar"
                    ],
                    "startAt" => [
                        "date" => "2016-06-10 00:00:00",
                        "timezone_type" =>  3,
                        "timezone"=>  "Europe/Madrid",
                    ],

                    "endAt" => [
                        "date" => "2016-06-18 00:00:00",
                        "timezone_type" =>  3,
                        "timezone"=>  "Europe/Madrid",
                    ],
                    "permalink" => "http://foo.bar",
                    "mapLocations" => [
                        [
                            "title"   => "Foo location",
                            "address" => "C/Foo 10",
                        ],
                        [
                            "title"   => "Bar location",
                            "address" => "C/Bar 10",
                        ],
                    ],
                    "assets" => [
                        [
                            "url" => "http://www.asset.foo",
                            "metadata" => [
                                "width"  => 100,
                                "height" => 100,
                            ]
                        ]
                    ],
                    "organizer" => [
                        "name" => "Foo organizer"
                    ]
                ],
            ]
        ];
    }
}