<?php

namespace Comitium5\CommonWidgetsBundle\Tests\PayWall\Worker;

use Comitium5\CommonWidgetsBundle\PayWall\Worker\PayWallWorker;
use Comitium5\CommonWidgetsBundle\Tests\PayWall\PayWallTestCase;

/**
 * Class PayWallWorker
 *
 * @author Óscar Jimenez <oscar@bab-soft.com>
 * @package Comitium5\CommonWidgetsBundle\Tests\PayWall\Worker
 */
class PayWallWorkerTest extends PayWallTestCase
{
    /**
     * @test
     * @throws \ReflectionException
     */
    public function workAndGetToken()
    {
        $worker = new PayWallWorker(
            $this->templatingService(),
            $this->cacheService(),
            $this->tokenService()
        );

        $token = $worker->workAndGetToken($this->payWallObject());

        $this->assertEquals('foo-token', $token);
    }

    /**
     * Test data is refreshed with the worker
     *
     * @test
     * @throws \ReflectionException|\Exception
     */
    public function fetchPrivateContentFromTokenFromEmptyCache()
    {
        $worker = new PayWallWorker(
            $this->templatingService(),
            $this->cacheService(true),
            $this->tokenService()
        );

        $content = $worker->fetchPrivateContent($this->payWallObject());

        $this->assertEquals("<div>foo</div>", $content);
    }

    /**
     * Test data is get from cache via worker
     *
     * @test
     * @throws \ReflectionException|\Exception
     */
    public function fetchPrivateContentFromTokenFromCache()
    {
        $worker = new PayWallWorker(
            $this->templatingService(),
            $this->cacheService(false),
            $this->tokenService()
        );

        $content = $worker->fetchPrivateContent($this->payWallObject());

        $this->assertEquals("<div>data from cache</div>", $content);
    }

    /**
     * Test data is get from cache via worker
     *
     * @test
     * @throws \ReflectionException|\Exception
     */
    public function fetchPayWallContentFromTokenFromEmptyCache()
    {
        $worker = new PayWallWorker(
            $this->templatingService(),
            $this->cacheService(true),
            $this->tokenService()
        );

        $content = $worker->fetchPayWallContent($this->payWallObject());

        $this->assertEquals("<div>Subscribe!</div>", $content);
    }

    /**
     * Test data is get from cache via worker
     *
     * @test
     * @throws \ReflectionException|\Exception
     */
    public function fetchPayWallContentFromTokenFromCache()
    {
        $worker = new PayWallWorker(
            $this->templatingService(),
            $this->cacheService(false),
            $this->tokenService()
        );

        $content = $worker->fetchPayWallContent($this->payWallObject());

        $this->assertEquals("<div>paywall content from cache</div>", $content);
    }
}
