<?php

namespace Comitium5\CommonWidgetsBundle\Search;

/**
 * Class ElasticResultParser
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\Search
 */
final class ElasticResultParser
{
    /**
     * @return array
     */
    private static function resultArray()
    {
        return [
            'page'  => 0,
            'total' => 0,
            'totalPages' => 0,
            'limit' => 0,
            'results' => [],
        ];
    }

    /**
     * @param \Elastica\ResultSet $results
     *
     * @return array
     */
    public static function parser($results)
    {
        $arrayResults = self::resultArray();

        $query = $results->getQuery();

        if ($query->hasParam('from') && $query->hasParam('size')) {
            $arrayResults['page']  = ($query->getParam('from') / $query->getParam('size')) + 1;
        }

        if ($query->hasParam('size')) {
            if ($query->getParam('size') > 0) {
                $arrayResults['limit']  = $query->getParam('size');
                $arrayResults['totalPages'] = ceil($results->getTotalHits() / $query->getParam('size'));
            }
        }

        $arrayResults['total'] = $results->getTotalHits();

        if ($results->count()) {
            foreach ($results as $result) {
                $hits = $result->getHit();

                if (!isset($hits['_source'])) {
                    continue;
                }

                $hit = $hits['_source'];

                if ($result->getHighlights()) {
                    $hit['_highLight'] = $result->getHighlights();
                }

                $arrayResults['results'][] = $hit;
            }
        }

        if ($results->getAggregations()) {
            $arrayResults['_aggregations'] = $results->getAggregations();
        }

        return $arrayResults;
    }
}
