<?php

namespace Comitium5\CommonWidgetsBundle\Normalizers\Poll;

use Comitium5\CommonWidgetsBundle\Utils\Common\CommonUtils;
use Predis\Client;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class PollRedisPushService
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\CommonWidgetsBundle\Normalizers\Poll
 */
class PollRedisPushService
{
    /**
     * @var string
     */
    const REDIS_KEY = 'poll_queue_%s';

    /**
     * @var Client
     */
    private $redisService;

    /**
     * @var Request
     */
    private $request;

    /**
     * @var int
     */
    private $answerId;

    /**
     * @var int
     */
    private $pollId;

    /**
     * PollRedisPushService constructor.
     *
     * TODO: Replace Client to CommonWidgetsBundle redis service when lpush method is implemented in it
     *
     * @param Client $redisService
     * @param Request $request
     * @param $answerId
     * @param $pollId
     */
    public function __construct(Client $redisService, Request $request, $answerId, $pollId)
    {
        $this->redisService = $redisService;
        $this->request = $request;
        $this->answerId = $answerId;
        $this->pollId = $pollId;
    }

    /**
     * @return bool
     * @throws \Exception
     */
    public function pushIntoRedis()
    {
        $data = $this->buildRequestData();

        try {
            $this
                ->redisService
                ->lpush(
                    $this->buildRedisKey(),
                    [json_encode($data)]
                );

            return true;
        } catch (\Exception $e) {
            return false;
        }
    }

    /**
     * @return string
     */
    private function buildRedisKey()
    {
        return sprintf(self::REDIS_KEY, $this->pollId);
    }

    /**
     * @return array
     * @throws \Exception
     */
    private function buildRequestData()
    {
        return [
            'ip'     => CommonUtils::getUserIp($this->request),
            'answer' => $this->answerId,
            'pollId' => $this->pollId,
            'date'   => (new \DateTime())->format('Y-m-d H:i:s'),
        ];
    }
}
