<?php

namespace Comitium5\CommonWidgetsBundle\Tests\Utils;

use Comitium5\CommonWidgetsBundle\Tests\TestCase;
use Comitium5\CommonWidgetsBundle\Utils\Assets\VideoUtils;

/**
 * Class VideoUtilsTest
 *
 * Joan Pont <joan.pont@bab-soft.com>
 * @package Comitium5\CommonWidgetsBundle\Tests\Utils
 */
class VideoUtilsTest extends TestCase
{
    /**
     * @dataProvider iframeTestingCases
     *
     * @param $embedCode
     * @param $result
     * vendor/bin/phpunit --filter testIsIframe Tests/Utils/VideoUtilsTest.php
     */
    public function testIsIframe($embedCode, $result)
    {
        $videoUtils = new VideoUtils("foo");

        $isIframe = $videoUtils->isIframe($embedCode);

        self::assertEquals($isIframe, $result);
    }

    /**
     * @return array
     */
    public function iframeTestingCases()
    {
        return [
            [
                '<p>Lorem Ipsum dolor sit amet </p><iframe src="http://foo.bar" title="" allowfullscreen></iframe><span class="badge">Foo bar</span>',
                true,
            ],
            [
                '<div><div>Lorem Ipsum dolor sit amet </div><iframe src="http://foo.bar" title="Bar" width="200" height="400"></iframe><img class="badge" src="http://wearebab.com" title="Foo bar" /></div>',
                true,
            ],
            [
                '<div><iframe src="" ></iframe></div>',
                true,
            ],
            [
                '<div><p class="style-1">Lorem Ipsum dolor sit amet</p></div>',
                false,
            ],
        ];
    }
}