<?php

namespace Comitium5\CommonWidgetsBundle\Tests\Utils;

use Comitium5\CommonWidgetsBundle\Tests\TestCase;
use Comitium5\CommonWidgetsBundle\Utils\Common\Checker\HtmlVideoChecker;

/**
 * Class HtmlVideoCheckerTest
 *
 * Joan Pont <joan.pont@bab-soft.com>
 * @package Comitium5\CommonWidgetsBundle\Tests\Utils
 */
class HtmlVideoCheckerTest extends TestCase
{
    /**
     * @param string $videoHtml
     *
     * @test
     * phpunit --filter testBodyWithVideo Tests/Utils/HtmlVideoCheckerTest.php
     * @dataProvider dataVideos
     */
    function testBodyWithVideo($videoHtml)
    {
        $body = $this->html($videoHtml);

        $this->assertTrue($this->checkHtml($body));
    }

    /**
     * @test
     * phpunit --filter testBodyWithoutVideo Tests/Utils/HtmlVideoCheckerTest.php
     */
    function testBodyWithoutVideo()
    {
        $body = $this->html();

        $this->assertFalse($this->checkHtml($body));
    }

    /**
     * @param $body
     *
     * @return bool
     */
    public function checkHtml($body)
    {
        return HtmlVideoChecker::check($body);
    }

    /**
     * @param string $content
     *
     * @return string
     */
    private function html($content = "")
    {
        return ('<p>El <strong>Wuhan Zall,&nbsp;</strong>del entrenador espa&ntilde;ol Jos&eacute; Gonz&aacute;lez,&nbsp;<a data-external="0" data-intl-links-es="https://www.elplural.com/sociedad/gobierno-andalucia-dejara-entrar-miercoles-malaga-equipo-ciudad-coronavirus_232110102" href="https://www.elplural.com/sociedad/gobierno-andalucia-dejara-entrar-miercoles-malaga-equipo-ciudad-coronavirus_232110102" rel="follow" target="_self" title="El Gobierno de Andalucía dejará entrar este miércoles en Málaga al equipo de la ciudad del coronavirus">realizar&aacute; su pretemporada en M&aacute;laga.</a> As&iacute; lo ha comunicado la Consejer&iacute;a de Salud y Familias de la Junta de Andaluc&iacute;a. Seg&uacute;n han comentado, el equipo ha estado entrenando en la ciudad de Guangzhou, a mil kil&oacute;metros de Wuhan, por lo que &#39;&#39;<strong>no estaban en la ciudad de origen del foco de Coronavirus cuando empez&oacute; su propagaci&oacute;n</strong>&#39;&#39;.&nbsp;</p><p>El equipo local de donde comenz&oacute; a propagarse el coronavirus, logr&oacute; alcanzar la sexta plaza en el campeonato liguero finalizado el pasado diciembre. Para preparar la temporada de cara a este nuevo campeonato que comenzar&aacute; a finales de febrero, el equipo dirigido por el entrenador gaditano ha elegido M&aacute;laga, ciudad del equipo del que fue entrenador, para realizar su pretemporada.&nbsp;</p><p>Liderados por el exjugador del <strong>Atl&eacute;tico de Madrid</strong>, L&eacute;o Baptist&atilde;o, llegan&nbsp;este mi&eacute;rcoles a la<strong> Costa del Sol</strong>, dentro de una&nbsp;pol&eacute;mica&nbsp;relacionada con&nbsp;el miedo a que el coronavirus llegue a Espa&ntilde;a y se pueda propagar por nuestro pa&iacute;s. A pesar de todas las alarmas de que alguien de Wuhan pueda pisar nuestro pa&iacute;s, los jugadores del equipo chino llegan<strong>&nbsp;sin presentar sintomatolog&iacute;a&nbsp;alguna relacionada con el virus.</strong></p><p>El Wuhan Zall, tras cinco a&ntilde;os de periplo por la segunda divisi&oacute;n del f&uacute;tbol profesional chino, logro alzarse con el primer puesto para subir a primera divisi&oacute;n. En la siguiente temporada y, gracias a los 12 goles que anot&oacute;&nbsp;<strong>Jean&nbsp;Kouassi</strong>, los de Gonz&aacute;lez acabaron la temporada en sexto lugar, la mejor clasificaci&oacute;n de su historia. Cabe destacar que este equipo se fund&oacute; en el a&ntilde;o 2009 tras haberse disuelto el<strong> Wuhan Guanggu</strong>.</p>'.$content);
    }

    public function dataVideos()
    {
        return [
            ['<p><iframe allow="accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture" allowfullscreen="" frameborder="0" height="315" src="https://www.youtube.com/embed/QwSMYg1UM30" width="560"></iframe></p>',],
            ['<p><iframe src="https://player.vimeo.com/video/307309034" width="640" height="360" frameborder="0" allow="autoplay; fullscreen" allowfullscreen></iframe><p><a href="https://vimeo.com/307309034">Video 3</a> from <a href="https://vimeo.com/cipertv">CiperTV</a> on <a href="https://vimeo.com">Vimeo</a>.</p></p>',],
            ['<p><iframe src="//www.ultimedia.com/deliver/generic/iframe/mdtk/03167617/src/ukupuk/zone/1/showtitle/1/" frameborder="0" scrolling="no" marginwidth="0" marginheight="0" hspace="0" vspace="0" webkitallowfullscreen="true" mozallowfullscreen="true" allowfullscreen="true"width="714" height="435" allow="autoplay; fullscreen"></iframe></p>',],
            ['<p><video width="320" height="240" controls><source src="movie.mp4" type="video/mp4"><source src="movie.ogg" type="video/ogg">Your browser does not support the video tag.</video></p>',],
        ];
    }
}
