<?php

namespace Comitium5\CommonWidgetsBundle\Tests\Services\Security;

use Comitium5\CommonWidgetsBundle\Services\Security\DataEncryption;
use Comitium5\CommonWidgetsBundle\Tests\TestCase;

/**
 * Class DataEncryptionTest
 *
 * @package Comitium5\CommonWidgetsBundle\Tests\Services\Security
 */
class DataEncryptionTest extends TestCase
{
    /**
     * @test
     * @throws \Exception
     * phpunit Tests/Services/Security/DataEncryptorTest.php
     */
    public function encryption()
    {
        $data = "this is a test";

        $service       = new DataEncryption($data);
        $encryptedData = $service->encrypt();

        $service       = new DataEncryption($encryptedData);
        $decryptedData = $service->decrypt();

        $this->assertEquals($data, $decryptedData);
    }

    /**
     * @test
     * @throws \Exception
     * phpunit Tests/Services/Security/DataEncryptorTest.php
     */
    public function uniqueToken()
    {
        $data = [
            'foo' => 1,
            'bar' => [
                'foo' => 'bar',
                'bar' => 'foo',
            ]
        ];

        $service = new DataEncryption(json_encode($data));
        $encryptedDataBase = $service->encrypt();

        for($x = 0; $x < 20; $x++) {
            $service = new DataEncryption(json_encode($data));
            $this->assertEquals($encryptedDataBase, $service->encrypt());
        }
    }

    /**
     * @test
     * @throws \Exception
     * phpunit Tests/Services/Security/DataEncryptorTest.php
     */
    public function encryptionErrorNonString()
    {
        $this->expectException(\Exception::class);

        new DataEncryption(["foo" => "bar"]);
    }

    /**
     * @test
     * @throws \Exception
     * phpunit Tests/Services/Security/DataEncryptorTest.php
     */
    public function encryptionErrorEmptyString()
    {
        $this->expectException(\Exception::class);

        new DataEncryption("  ");
    }
}
