<?php

namespace Comitium5\CommonWidgetsBundle\Services\Poll;

use Comitium5\ApiClientBundle\Client\Client;
use Comitium5\ApiClientBundle\Client\Services\PollApiService;
use Comitium5\ApiClientBundle\ValueObject\IdentifiedValue;
use Comitium5\CommonWidgetsBundle\Normalizers\Poll\PollNormalizer;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Class PollService
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\CommonWidgetsBundle\Services\Poll
 */
class PollService
{
    /**
     * @var Client
     */
    protected $api;

    /**
     * @var
     */
    protected $pollId;

    /**
     * PollService constructor.
     *
     * @param Client $api
     * @param $pollId
     */
    public function __construct(Client $api, $pollId)
    {
        $this->api    = $api;
        $this->pollId = $pollId;
    }

    /**
     * @return JsonResponse
     * @throws \Exception
     */
    public function resolvePoll()
    {
        $poll = PollNormalizer::normalize($this->fetchPoll());

        return $this->resolveResponse($poll);
    }

    /**
     * @return array|mixed
     * @throws \Exception
     */
    public function fetchPoll()
    {
        $pollService = new PollApiService($this->api);

        return $pollService->find(new IdentifiedValue($this->pollId));
    }

    /**
     * @param array $poll
     *
     * @return JsonResponse
     */
    protected function resolveResponse(array $poll)
    {
        $response = new JsonResponse($poll);

        $response->setSharedMaxAge(200);

        $response->headers->addCacheControlDirective('must-revalidate', true);

        return $response;
    }
}
