<?php

namespace Comitium5\CommonWidgetsBundle\Services;

use Comitium5\CommonWidgetsBundle\Services\Interfaces\DataBaseConnectionInterface;
use Doctrine\DBAL\DriverManager;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Statement;

/**
 * Class ExternalDataBaseConnection
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\Services
 */
class ExternalDataBaseConnection implements DataBaseConnectionInterface
{
    /**
     * @var Connection
     */
    protected $connection;

    /**
     * @var Statement
     */
    protected $statement;

    /**
     * @param $stringConnection
     * @return $this
     * @throws \Doctrine\DBAL\DBALException
     */
    public function connect($stringConnection)
    {
        $this->connection = DriverManager::getConnection([
            "url" => $stringConnection
        ]);

        return $this;
    }

    /**
     *
     */
    public function disconnect()
    {
        if ($this->connection) {
            $this->connection->close();
        }
    }

    /**
     * @param $query
     * @return mixed
     */
    public function execute($query)
    {
        $this->connection->query($query);

        $this->statement = $this->connection->prepare($query);

        return $this->statement->execute();
    }

    /**
     * @param Statement $statement
     * @return $this
     */
    public function setStatement(Statement $statement)
    {
        $this->statement = $statement;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getStatement()
    {
        return $this->statement;
    }

    /**
     * @param Connection $connection
     * @return $this
     */
    public function setConnection(Connection $connection)
    {
        $this->connection = $connection;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getConnection()
    {
        return $this->connection;
    }
}