<?php

namespace Comitium5\CommonWidgetsBundle\Tests\PayWall\Token;

use Comitium5\CommonWidgetsBundle\PayWall\Token\PayWallToken;
use Comitium5\CommonWidgetsBundle\PayWall\ValueObject\PayWallObject;
use Comitium5\CommonWidgetsBundle\Tests\PayWall\PayWallTestCase;

/**
 * Class PayWallTokenTest
 *
 * @author Óscar Jimenez <oscar@bab-soft.com>
 * @package Comitium5\CommonWidgetsBundle\Tests\PayWall\Token
 */
class PayWallTokenTest extends PayWallTestCase
{
    /**
     * @test
     * @throws \ReflectionException
     */
    public function encryptAndDecrypt()
    {
        $payWallToken = new PayWallToken();

        $token = $payWallToken->encrypt($this->payWallObject());

        $this->assertNotEmpty($token);

        $payWallToken = new PayWallToken();

        $payWallToken = $payWallToken->decrypt($token);

        $this->assertInstanceOf(PayWallObject::class, $payWallToken);
        $this->assertEquals(1234, $payWallToken->getObjectId());
        $this->assertEquals('articles', $payWallToken->getObjectType());
        $this->assertEquals(
            [
                ["id" => 100],
                ["id" => 200],
                ["id" => 300],
            ],
            $payWallToken->getObjectSubscriptions()
        );
        $this->assertEquals('paywall-private.html.twig', $payWallToken->getPrivateContentTemplate());
        $this->assertEquals(['id' => 1234, 'title' => 'foo'], $payWallToken->getPrivateContentData());
        $this->assertEquals('paywall-subscription.html.twig', $payWallToken->getPayWallTemplate());
        $this->assertEquals(['title' => 'Subscribe!'], $payWallToken->getPayWallTemplateData());
        $this->assertEquals('__PAYWALL__', $payWallToken->getCacheKeyPrefix());
        $this->assertEquals(300, $payWallToken->getCacheTTL());
        $this->assertEquals(['type' => 'hard', 'data' => []], $payWallToken->getPayWallOptions());
    }

    /**
     * @test
     * @throws \Exception
     */
    public function failsDecrypt()
    {
        $this->expectExceptionMessage('Invalid token for paywall decryption');

        $payWallToken = new PayWallToken();

        $payWallToken->decrypt('some-invalid-token');
    }
}