<?php

namespace Comitium5\CommonWidgetsBundle\Tests\PayWall;

use Comitium5\CommonWidgetsBundle\Cache\MemoryCacheInterface;
use Comitium5\CommonWidgetsBundle\PayWall\Token\PayWallToken;
use Comitium5\CommonWidgetsBundle\PayWall\ValueObject\PayWallObject;
use Comitium5\CommonWidgetsBundle\Tests\TestCase;
use Symfony\Component\Templating\EngineInterface;

/**
 * Class PayWallTestCase
 *
 * @author Óscar Jimenez <oscar@bab-soft.com>
 * @package Comitium5\CommonWidgetsBundle\Tests\PayWall
 */
class PayWallTestCase extends TestCase
{
    /**
     * @param array $payWallOptions
     *
     * @return PayWallObject
     * @throws \Exception
     */
    protected function payWallObject($payWallOptions = [])
    {
        return new PayWallObject(
            1234,
            'articles',
            [
                ["id" => 100],
                ["id" => 200],
                ["id" => 300],
            ],
            'paywall-private.html.twig',
            ['id' => 1234, 'title' => 'foo'],
            'paywall-subscription.html.twig',
            ['title' => 'Subscribe!'],
            300,
            120,
            $payWallOptions
        );
    }


    /**
     * @return \PHPUnit\Framework\MockObject\MockObject
     * @throws \ReflectionException
     */
    protected function templatingService()
    {
        $stub = $this->createMock(EngineInterface::class);

        $stub
            ->method('render')
            ->willReturnCallback(function($name, array $parameters = []){

                $content  = '<div>';
                $content .= $parameters['title'];
                $content .= '</div>';

                return $content;
            });

        return $stub;
    }

    /**
     * @param $emptyCache
     *
     * @return \PHPUnit\Framework\MockObject\MockObject
     * @throws \ReflectionException
     */
    protected function cacheService($emptyCache = false)
    {
        $stub = $this->createMock(MemoryCacheInterface::class);

        $stub
            ->method('set')
            ->willReturn(true)
        ;

        $stub
            ->method('get')
            ->willReturnCallback(function($key) use($emptyCache) {
                if ($emptyCache === true) {
                    return '';
                }

                if ($key === '__PAYWALL__articles__1234') {
                    return "<div>data from cache</div>";
                }

                return "<div>paywall content from cache</div>";
            })
        ;

        return $stub;
    }

    /**
     * @return \PHPUnit\Framework\MockObject\MockObject
     * @throws \ReflectionException
     */
    protected function tokenService()
    {
        $stub = $this->createMock(PayWallToken::class);

        $stub
            ->method('encrypt')
            ->willReturn('foo-token')
        ;

        $stub
            ->method('decrypt')
            ->willReturnCallback(function(){
                return $this->payWallObject();
            })
        ;

        return $stub;
    }
}