<?php

namespace Comitium5\CommonWidgetsBundle\Utils\Dates;

/**
 * Class DateUtils
 *
 * @author Oscar Jimenez <oscarjg19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\Utils\Common
 */
class DateUtils
{
    /**
     * @var string
     */
    public static $defaultLocale = "en";

    /**
     * @param $locale
     *
     * @return mixed
     */
    public static function buildLocale($locale)
    {
        $locales = [
            "en" => "en_EN",
            "ca" => "ca_CA",
            "es" => "es_ES",
        ];

        return isset($locales[$locale]) ? $locales[$locale] : $locales[self::$defaultLocale];
    }

    /**
     * @param \DateTime $date
     * @param string    $locale
     *
     * @return string
     */
    public static function buildPrefix(\DateTime $date, $locale = "en")
    {
        if ($locale === "en") {
            return "of ";
        }

        if ($locale === "es") {
            return "de ";
        }

        if ($locale === "ca") {
            $monthDay = $date->format('n');

            if (in_array($monthDay, [4, 8, 10])) {
                return "d'";
            }

            return "de ";
        }
    }

    /**
     * @param \DateTime $date
     * @param string    $locale
     * @param null      $format
     *
     * @return string
     */
    public static function date(\DateTime $date = null, $locale = "en", $format = null, $dateType = \IntlDateFormatter::LONG, $timeType = \IntlDateFormatter::NONE, $timezone = null, $calendar = \IntlDateFormatter::GREGORIAN )
    {
        $intl = new \IntlDateFormatter(self::buildLocale($locale), $dateType, $timeType, $timezone, $calendar, $format);

        return ucfirst($intl->format($date));
    }

    /**
     * @param \DateTime|null $date
     * @param string $locale
     * @param null $prefix
     *
     * @return string
     */
    public static function month(\DateTime $date = null, $locale = "en", $prefix = null)
    {
        $month = self::date($date, $locale, "LLLL");

        return $prefix === null ? self::buildPrefix($date, $locale).$month : sprintf($prefix."%s".$month, $prefix ? " ": "");
    }

    /**
     * @param \DateTime $date
     * @param string    $locale
     *
     * @return string
     */
    public static function day(\DateTime $date = null, $locale = "en")
    {
        return self::date($date, $locale, "cccc");
    }
}
