<?php

namespace Comitium5\CommonWidgetsBundle\MailingStats;

/**
 * Class StatsUtils
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\MailingStats
 */
class StatsUtils
{
    const ENCODE_PARAM = "_d";
    const REDIRECT_PARAM = "_r";
    const CAMPAIGN_ID_PARAM = "_cid";
    const EMAIL_PARAM = "_e";
    const EXTRA_DATA_PARAM = "_ext";

    /**
     * @param array $data
     * @return string
     */
    public static function encode(array $data)
    {
        return base64_encode(json_encode($data));
    }

    /**
     * @param array $data
     * @return string
     */
    public static function encodeString($data)
    {
        return base64_encode($data);
    }

    /**
     * @param $data
     * @return array
     */
    public static function decode($data)
    {
        $data = base64_decode($data);

        return json_decode($data, true);
    }
}