<?php

namespace Comitium5\CommonWidgetsBundle\Controller;

use Comitium5\CommonWidgetsBundle\MailingStats\StatsManager;
use Comitium5\CommonWidgetsBundle\MailingStats\StatsUtils;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class ComputeStats
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Controller
 */
class ComputeMailingStatsController
{
    /**
     * @var StatsManager
     */
    protected $statsManager;

    /**
     * ComputeMailingStatsController constructor.
     * @param StatsManager $statsManager
     */
    public function __construct(StatsManager $statsManager)
    {
        $this->statsManager = $statsManager;
    }

    /**
     * @return RedirectResponse
     */
    public function computeClickAction()
    {
        $request = Request::createFromGlobals();

        $data = $request
            ->query
            ->get(StatsUtils::ENCODE_PARAM);

        try {
            $this
                ->statsManager
                ->persistClickFromRequestData($data);

            $data = StatsUtils::decode($data);

            $redirectUrl = $data[StatsUtils::REDIRECT_PARAM];

            return new RedirectResponse($redirectUrl);
        } catch (\Throwable $e) {
            return new Response();
        }
    }

    /**
     * @return Response
     */
    public function computeOpenAction()
    {
        $request = Request::createFromGlobals();

        $data = $request
            ->query
            ->get(StatsUtils::ENCODE_PARAM);

        try {
            $this
                ->statsManager
                ->persistOpenFromRequestData($data);
        } catch (\Throwable $e) {
            // Do nothing and return empty css as usual
        }

        return new Response("", Response::HTTP_OK, ["content-type" => "text/css"]);
    }
}
