<?php

namespace Comitium5\CommonWidgetsBundle\Factory\Cache;

use Predis\Client;

/**
 * Class RedisFactory
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\CommonWidgetsBundle\Factory\Cache
 */
class RedisFactory
{
    /**
     * @param string $host
     * @param string $scheme
     * @param string $port
     * @param string $database
     *
     * @return Client
     */
    public function create($host, $scheme, $port, $database)
    {
        return new Client(
            [
                "host"     => $host,
                "scheme"   => $scheme,
                "port"     => $port,
                "database" => $database,
            ]
        );
    }
}
