<?php

namespace Comitium5\CommonWidgetsBundle\Controller;


use Symfony\Bundle\FrameworkBundle\Controller\Controller;

class AbstractController extends Controller
{
    /**
     * @param $controllerNameSpace
     *
     * @param $action
     *
     * @return string
     * @throws \Exception
     */
    protected function buildControllerInstance($controllerNameSpace, $action)
    {
        self::checkValidController($controllerNameSpace, $action);

        $controller = urldecode($controllerNameSpace);

        if (!class_exists($controller)) {
            throw new \Exception("Controller class not found");
        }

        $controller = new $controller();

        if (!method_exists($controller, $action)) {
            throw new \Exception("Method doesn't exists");
        }

        if (!$controller instanceof Controller) {
            throw new \Exception("Controller class must be instance of Symfony2 controller");
        }

        $controller->setContainer($this->container);

        return $controller;
    }

    /**
     * @param $namespace
     * @param $action
     *
     * @throws \Exception
     */
    protected static function checkValidController($namespace, $action)
    {
        if ($namespace === null || $action === null) {
            throw new \Exception("Controller and action params are mandatory params");
        }
    }

    /**
     * @param $parameters
     *
     * @return array|mixed
     */
    protected static function buildParameters($parameters)
    {
        if ($parameters === null) {
            return [];
        }

        if (is_array($parameters)) {
            return $parameters;
        }

        return json_decode(htmlspecialchars_decode($parameters), true);
    }
}