<?php

namespace Comitium5\CommonWidgetsBundle\Tests\RichSnippets;

use Comitium5\CommonWidgetsBundle\Tests\TestCase;
use Comitium5\CommonWidgetsBundle\Utils\RichSnippets\RichSnippets;

/**
 * Class ActivityRichSnippetsTest
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\Tests\Search
 */
class RichSnippetsTest extends TestCase
{
    /**
     * @dataProvider items
     * vendor/bin/phpunit Tests/RichSnippets/RichSnippetsTest.php
     */
    public function testItemList($items)
    {
        $data = RichSnippets::itemListsRichSnippet($items);

        $json = [
            "@context"        => "http://schema.org",
            "@type"           => "ItemList",
            "itemListElement" => [
               [
                   "@type"    => "ListItem",
                    "position" => 1,
                    "url"      => "http://foo.bar",
               ], [
                    "@type"    => "ListItem",
                    "position" => 2,
                    "url"      => "http://foo.bar",
                ], [
                    "@type"    => "ListItem",
                    "position" => 3,
                    "url"      => "",
                ]
            ],
        ];

        $this->assertEquals($data, $json);
    }

    /**
     * @return array
     */
    public function items()
    {
        return [
            [
                [
                    [
                        "id" => 1,
                        "permalink" => "http://foo.bar",
                    ],[
                        "id" => 2,
                        "permalink" => "http://foo.bar",
                    ], [
                        "id" => 3,
                    ],
                ],
            ]
        ];
    }
}