<?php

namespace Comitium5\CommonWidgetsBundle\DependencyInjection\Compiler;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;

/**
 * Class ConfigLoaderPass
 *
 * @author Óscar Jimenez <oscar@bab-soft.com>
 * @package DependencyInjection\Compiler
 */
class ConfigLoaderPass implements CompilerPassInterface
{
    const SERVICE_NAME = 'comitium5_common_widgets.subsite_config_loader';

    /**
     * @param ContainerBuilder $container
     *
     * @throws \Exception
     */
    public function process(ContainerBuilder $container)
    {
        if ($container->has(self::SERVICE_NAME)) {
            $container->get(self::SERVICE_NAME);
        }
    }

}