<?php

namespace Comitium5\CommonWidgetsBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class RequestController
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\Controller
 */
class RequestController extends AbstractController
{
    /**
     * Function to call your widget via Ajax
     */
    public function selfCallAction()
    {
        try {
            $request = $this->get('request_stack')->getMasterRequest();

            $controllerNamespace = $request->get('controller', null);
            $action = $request->get('action', null);
            $parameters = $this->buildParameters($request->get('parameters'));
            $controller = $this->buildControllerInstance($controllerNamespace, $action);

            return $controller->$action($parameters);
        } catch (\Exception $e) {
            return new Response($e->getMessage(), Response::HTTP_BAD_REQUEST);
        }
    }
}
