<?php

namespace Comitium5\CommonWidgetsBundle\ValueObject\Mailer;

use Symfony\Component\Templating\EngineInterface;

/**
 * Class MailerValueObject
 * @package Comitium5\CommonWidgetsBundle\ValueObject\Mailer
 */
class SwiftMailerTemplating extends SwiftMailer
{
    /**
     * @var EngineInterface
     */
    protected $templating;

    /**
     * @var string
     */
    protected $locale;

    /**
     * SwiftMailerTemplating constructor.
     * @param $to
     * @param $from
     * @param $fromName
     * @param \Swift_Mailer $mailer
     * @param $locale
     * @param EngineInterface $templating
     * @param array $bcc
     */
    public function __construct(
        $to,
        $from,
        $fromName,
        \Swift_Mailer $mailer,
        $locale,
        EngineInterface $templating,
        $bcc = []
    ) {
        parent::__construct($to, $from, $fromName, $mailer, $bcc);

        $this->templating = $templating;
    }

    /**
     * @return EngineInterface
     */
    public function getTemplating()
    {
        return $this->templating;
    }

    /**
     * @return string
     */
    public function getLocale()
    {
        return $this->locale;
    }
}