<?php

namespace Comitium5\CommonWidgetsBundle\ValueObject\Mailer;

/**
 * Class MailerValueObject
 * @package Comitium5\CommonWidgetsBundle\ValueObject\Mailer
 */
class SwiftMailer
{
    /**
     * @var string
     */
    protected $to;

    /**
     * @var string
     */
    protected $from;

    /**
     * @var string
     */
    protected $fromName;

    /**
     * @var array
     */
    protected $bcc;

    /**
     * @var \Swift_Mailer
     */
    protected $mailer;

    /**
     * SwiftMailer constructor.
     * @param $to
     * @param $from
     * @param $fromName
     * @param \Swift_Mailer $mailer
     * @param array $bcc
     */
    public function __construct(
        $to,
        $from,
        $fromName,
        \Swift_Mailer $mailer,
        $bcc = []
    ) {
        $this->to = $to;
        $this->from = $from;
        $this->fromName = $fromName;
        $this->mailer = $mailer;
        $this->bcc = $bcc;
    }

    /**
     * @return mixed
     */
    public function getTo()
    {
        return $this->to;
    }

    /**
     * @return mixed
     */
    public function getFrom()
    {
        return $this->from;
    }

    /**
     * @return mixed
     */
    public function getFromName()
    {
        return $this->fromName;
    }

    /**
     * @return \Swift_Mailer
     */
    public function getMailer()
    {
        return $this->mailer;
    }

    /**
     * @return null
     */
    public function getBcc()
    {
        return $this->bcc;
    }
}