<?php

namespace Comitium5\CommonWidgetsBundle\Services\Mailer;

use Comitium5\CommonWidgetsBundle\ValueObject\Mailer\SwiftMailerTemplating;

/**
 * Class MailerService
 * @package Comitium5\CommonWidgetsBundle\Services
 */
class SwiftMailerTemplatingService
{
    /**
     * @var SwiftMailerTemplating
     */
    protected $mailerValueObject;

    /**
     * SwiftMailerTemplatingService constructor.
     * @param SwiftMailerTemplating $mailerValueObject
     */
    public function __construct(SwiftMailerTemplating $mailerValueObject)
    {
        $this->mailerValueObject = $mailerValueObject;
    }

    /**
     * @param $template
     * @param array $data
     * @param $to
     * @param $subject
     * @return int
     */
    public function sendMail(
        $template,
        array $data,
        $to,
        $subject
    ) {
        $data = array_merge(
            $data,
            ['locale' => $this->mailerValueObject->getLocale()]
        );

        $content = $this
            ->renderContent(
                $template,
                $data
        );

        $message = $this->createMessageInstance(
            $subject,
            $to,
            $content
        );

        return $this->send($message);
    }

    /**
     * @param $template
     * @param $data
     * @return string
     */
    protected function renderContent($template, $data)
    {
        return $this
            ->mailerValueObject
            ->getTemplating()
            ->render(
                $template,
                $data
            );
    }

    /**
     * @param $subject
     * @param $to
     * @param $content
     * @return \Swift_Message
     */
    protected function createMessageInstance($subject, $to, $content)
    {
        $message = \Swift_Message::newInstance();

        $message
            ->setSubject($subject)
            ->setTo($to)
            ->setFrom($this->mailerValueObject->getFrom(), $this->mailerValueObject->getFromName())
            ->setBody($content, 'text/html')
            ->setBcc($this->mailerValueObject->getBcc())
        ;

        return $message;
    }

    /**
     * @param \Swift_Message $message
     * @return int
     */
    protected function send(\Swift_Message $message)
    {
        return $this
            ->mailerValueObject
            ->getMailer()
            ->send($message);
    }
}