<?php

namespace Comitium5\CommonWidgetsBundle\Services\Mailer;

use Comitium5\CommonWidgetsBundle\ValueObject\Mailer\SwiftMailer;

/**
 * Class MailerService
 * @package Comitium5\CommonWidgetsBundle\Services
 */
class SwiftMailerService
{
    /**
     * @var SwiftMailer
     */
    protected $mailerValueObject;

    /**
     * SwiftMailerService constructor.
     * @param SwiftMailer $mailerValueObject
     */
    public function __construct(SwiftMailer $mailerValueObject)
    {
        $this->mailerValueObject = $mailerValueObject;
    }

    /**
     * @param $content
     * @param $to
     * @param $subject
     * @return mixed
     */
    public function sendMail(
        $content,
        $to,
        $subject
    ) {
        $message = $this->createMessageInstance(
            $subject,
            $to,
            $content
        );

        return $this->send($message);
    }

    /**
     * @param $subject
     * @param $to
     * @param $content
     * @return \Swift_Message
     */
    protected function createMessageInstance($subject, $to, $content)
    {
        $message = \Swift_Message::newInstance();

        $message
            ->setSubject($subject)
            ->setTo($to)
            ->setFrom($this->mailerValueObject->getFrom(), $this->mailerValueObject->getFromName())
            ->setBody($content, 'text/html')
            ->setBcc($this->mailerValueObject->getBcc())
        ;

        return $message;
    }

    /**
     * @param \Swift_Message $message
     * @return int
     */
    protected function send(\Swift_Message $message)
    {
        return $this
            ->mailerValueObject
            ->getMailer()
            ->send($message);
    }
}