<?php

namespace Comitium5\CommonWidgetsBundle\MailingStats;

use Comitium5\CommonWidgetsBundle\Cache\MemoryCacheInterface;

/**
 * Class StatsManager
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\MailingStats
 */
class StatsManager
{
    const CACHE_KEY_PREFIX = "cs_mailing_stats_";
    const CACHE_TTL        = 172800;

    /**
     * @var MemoryCacheInterface
     */
    private $cacheService;

    /**
     * StatsManager constructor.
     * @param MemoryCacheInterface $cacheService
     */
    public function __construct(MemoryCacheInterface $cacheService)
    {
        $this->cacheService = $cacheService;
    }

    /**
     * @param array $data
     * @return bool
     * @throws \Exception
     */
    public static function isValidData(array $data)
    {
        if (
            empty($data[StatsUtils::EMAIL_PARAM]) ||
            empty($data[StatsUtils::CAMPAIGN_ID_PARAM])
        ) {
            throw new \Exception("Invalid data to persist click stats");
        }

        return true;
    }

    /**
     * @param string $data
     * @throws \Exception
     */
    public function persistClickFromRequestData($data)
    {
        $parseData = self::parseData(StatsUtils::decode($data));

        $key = self::generateKey(
            "click",
            $parseData["campaignId"],
            $parseData["email"]
        );

        $this
            ->cacheService
            ->set($key, $data, self::CACHE_TTL);
    }

    /**
     * @param string $data
     */
    public function persistOpenFromRequestData($data)
    {
        $parseData = self::parseData(StatsUtils::decode($data));

        $key = self::generateKey(
            "open",
            $parseData["campaignId"],
            $parseData["email"]
        );

        $this
            ->cacheService
            ->set($key, $data, self::CACHE_TTL);
    }

    /**
     * @param $statType
     * @param $campaignId
     * @param $email
     * @return string
     */
    public static function generateKey(
        $statType,
        $campaignId,
        $email,
        $random = null
    ) {
        $key  = self::CACHE_KEY_PREFIX;
        $key .= $statType . "_%s_%s_%s";

        $key = sprintf($key, $campaignId, StatsUtils::encodeString($email), $random ? : uniqid());

        return $key;
    }

    /**
     * @param array $data
     * @return array
     * @throws \Exception
     */
    public static function parseData(array $data)
    {
        self::isValidData($data);

        return [
            "campaignId" => $data[StatsUtils::CAMPAIGN_ID_PARAM],
            "email"      => $data[StatsUtils::EMAIL_PARAM],
            "extraData"  => empty($data[StatsUtils::EXTRA_DATA_PARAM]) ? null : $data[StatsUtils::EXTRA_DATA_PARAM],
        ];
    }
}
