<?php

namespace Comitium5\CommonWidgetsBundle\Exceptions;

/**
 * Class WidgetControllerErrorException
 *
 * @author Oscar Jimenez <oscargj19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\Exceptions
 */
class WidgetControllerErrorException extends \Exception
{
    /**
     * @var AbstractWidgetController
     */
    private $widgetController;

    /**
     * @param $widgetController
     * @param string $message
     * @param int    $code
     */
    public function __construct($widgetController, $message = "", $code = 0)
    {
        $this->widgetController = $widgetController;

        parent::__construct($message, $code);
    }

    /**
     * @return mixed
     */
    public function getWidgetController()
    {
        return $this->widgetController;
    }

    /**
     * @param mixed $widgetController
     */
    public function setWidgetController($widgetController)
    {
        $this->widgetController = $widgetController;
    }
}
