<?php

namespace Comitium5\CommonWidgetsBundle\Tests\Utils;

use Comitium5\CommonWidgetsBundle\Tests\TestCase;
use Comitium5\CommonWidgetsBundle\Utils\Assets\AssetsUtils;
use Comitium5\CommonWidgetsBundle\Utils\Common\CommonUtils;

/**
 * Class AssetsUtilsTest
 *
 * @package Comitium5\CommonWidgetsBundle\Tests\Utils
 * @author Oscar Jimenez <oscarjg19.developer@gmail.com>
 */
class AssetsUtilsTest extends TestCase
{
    /**
     * @test
     * phpunit --filter getChildrenMatchCrops Tests/Utils/AssetsUtilsTest.php
     */
    public function getChildrenMatchCrops()
    {
        $asset = [
            "url" => "http://original.jpeg",
            "children" => [
                ["metadata" => ["width" => 1600, "height" => 400], "url" => "http://foo.bar_1"],
                ["metadata" => ["width" => 800, "height"  => 200], "url" => "http://foo.bar_2"],
                ["metadata" => ["width" => 400, "height"  => 100], "url" => "http://foo.bar_3"],
                ["metadata" => ["width" => 400, "height"  => 100], "url" => "http://foo.bar_4"],
                ["metadata" => ["width" => 100, "height"  => 500], "url" => "http://foo.bar_5"],
            ],
        ];

        $matches = [
            "(max-width: 100px)" => '800|200',
            "(min-width: 101px) and (max-width: 500px)" => '400|100',
            "(min-width: 399px) and (max-width: 700px)" => '100|500',
            "(min-width: 701px)" => '100|500',
        ];

        $data = AssetsUtils::getChildrenMatchCrops($asset, $matches);

        $this->assertEquals($data, [
                "(max-width: 100px)" => "http://foo.bar_2",
                "(min-width: 101px) and (max-width: 500px)" => "http://foo.bar_4",
                "(min-width: 399px) and (max-width: 700px)" => "http://foo.bar_5",
                "(min-width: 701px)" => "http://foo.bar_5",
            ]
        );

        //No crop candidate
        $matches = ["(max-width: 100px)" => '400|200'];

        $data = AssetsUtils::getChildrenMatchCrops($asset, $matches);

        $this->assertEquals($data, []);

        // No crop candidate
        $matches = [
            "(max-width: 100px)" => '400|200',
            "(max-width: 500px)" => '400|100',
        ];

        $data = AssetsUtils::getChildrenMatchCrops($asset, $matches);

        $this->assertEquals($data, ["(max-width: 500px)" => "http://foo.bar_4"]);
    }
}
