<?php

namespace Comitium5\CommonWidgetsBundle\Services;

use Comitium5\CommonWidgetsBundle\Controller\AbstractWidgetControllerBase;
use Symfony\Component\Yaml\Yaml;

/**
 * Class SubSiteConfigLoader
 *
 * @author Óscar Jimenez <oscar@bab-soft.com>
 * @package ComitiumSuite\Bundle\CSBundle\Widgets\Core\Services
 */
class SubSiteConfigLoader extends AbstractWidgetControllerBase
{
    /**
     * @var array
     */
    public static $fileContent = [];

    /**
     * @var string
     */
    protected static $filePath;

    /**
     * @param $key
     * @param array $subSite
     *
     * @return null
     * @throws \Exception
     */
    public static function getValue($key, array $subSite = [])
    {
        $fileName = self::resolveFileName($subSite);

        self::setFileContent($fileName);

        if (isset(self::$fileContent[$fileName][$key])) {
            return self::$fileContent[$fileName][$key];
        }

        return null;
    }

    /**
     * @param $path
     */
    public static function setConfigFilePath($path)
    {
        self::$filePath = $path;
    }

    /**
     * @param $fileName
     *
     * @return mixed
     */
    protected static function setFileContent($fileName)
    {
        if (isset(self::$fileContent[$fileName])) {
            return self::$fileContent[$fileName];
        }

        self::$fileContent[$fileName] = self::readAndParseFile($fileName);
    }

    /**
     * @param $fileName
     *
     * @return mixed
     */
    protected static function readAndParseFile($fileName)
    {
        return Yaml::parse(file_get_contents(self::resolveFilePath($fileName)));
    }

    /**
     * @param array $subSite
     *
     * @return string
     * @throws \Exception
     */
    protected static function resolveFileName($subSite = [])
    {
        $subSite = empty($subSite) ? self::getSubsite() : $subSite;

        $subSiteAcronym = $subSite['acronym'];

        if (file_exists(sprintf(self::$filePath, $subSiteAcronym))) {
            return $subSiteAcronym;
        }

        if (file_exists(sprintf(self::$filePath, 'default'))) {
            return 'default';
        }

        throw new \Exception("There ara no ".$subSiteAcronym.".yaml or default.yaml files.");
    }

    /**
     * @param $fileName
     *
     * @return string
     */
    protected static function resolveFilePath($fileName)
    {
        return self::$filePath . DIRECTORY_SEPARATOR . $fileName . '.yaml';
    }
}
