<?php

namespace Comitium5\CommonWidgetsBundle\Utils\RichSnippets;

use Comitium5\CommonWidgetsBundle\Utils\Common\CommonUtils;

/**
 * Class ActivityRichSnippets
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\Utils\RichSnippets
 */
class ActivityRichSnippets implements GoogleSnippetsInterface
{
    /**
     * @var int
     */
    public static $maxTitleLength = 110;

    /**
     * @var string
     */
    public static $defaultCompleteText = "...";

    /**
     * @param array $entity
     * @return array
     */
    public static function googleRichSnippet(array $entity)
    {
        $title = !empty($entity['lang']["title"]) ? trim($entity['lang']['title']) : "";

        if (mb_strlen($title) > self::$maxTitleLength) {
            $title = trim(mb_substr($title, 0, (self::$maxTitleLength - mb_strlen(self::$defaultCompleteText) ))).self::$defaultCompleteText;
        }

        $description = !empty($entity['lang']["description"]) ? trim(strip_tags($entity['lang']['description'])) : "";

        if (!empty($entity['startAt'])) {
            $startDate = CommonUtils::instanceDateTimeFromArray($entity['startAt']);
        } elseif (!empty($entity['publishedAt'])) {
            $startDate = CommonUtils::instanceDateTimeFromArray($entity['publishedAt']);
        } else {
            $startDate = new \DateTime();
        }

        if (!empty($entity['endAt'])) {
            $endDate   = CommonUtils::instanceDateTimeFromArray($entity['endAt']);
        } else {
            $endDate = new \DateTime("NOW + 1 YEAR");
        }

        $url = !empty($entity["permalink"]) ? $entity["permalink"] : "";

        $locationName    = "";
        $locationAddress = "";

        if (!empty($entity["mapLocations"]) && is_array($entity["mapLocations"])) {
            $firstLocation   = $entity["mapLocations"][0];
            $locationName    = !empty($firstLocation["title"]) ? $firstLocation["title"] : $locationName;
            $locationAddress = !empty($firstLocation["address"]) ? $firstLocation["address"] : $locationAddress;
        }

        $location = [
            "@type"   => self::LOCATION_TYPE,
            "name"    => $locationName,
            "address" => $locationAddress,
         ];

        $image = [];

        if (!empty($entity["assets"]) && is_array($entity["assets"])) {
            $firstAsset = $entity["assets"][0];

            $image =  [
                '@type'  => self::IMAGE_OBJECT_LABEL,
                'url'    => !empty($firstAsset["url"]) ? $firstAsset["url"] : "",
                'width'  => !empty($firstAsset["metadata"]["width"]) ? $firstAsset["metadata"]["width"] : "",
                'height' => !empty($firstAsset["metadata"]["height"]) ? $firstAsset["metadata"]["height"] : "",
            ];
        }

        $offers = [
            "url"   => $url,
            "name"  => $title,
            "price" => isset($entity["free"]) && $entity["free"] === true ? 0 : !empty($entity["price"]) ? $entity["price"] : 0,
        ];

        $performer = null;

        if (!empty($entity["organizer"]["name"])) {
            $performer = $entity["organizer"]["name"];
        }

        $json = [
            "@context"    => self::SCHEMA_ORG_URL,
            "@type"       => self::GOOGlE_ACTIVITY_TYPE,
            "name"        => $title,
            "description" => $description,
            "startDate"   => $startDate instanceof \DateTime ? $startDate->format(\DateTime::ISO8601) : "",
            "endDate"     => $endDate instanceof \DateTime ? $endDate->format(\DateTime::ISO8601): "",
            "url"         => $url,
            "location"    => $location,
            "offers"      => $offers,
        ];


        if (!empty($image)) {
            $json["image"] = $image;
        }

        if (!empty($performer)) {
            $json["performer"] = $performer;
        }

        return $json;
    }
}