<?php

namespace Comitium5\CommonWidgetsBundle\Tests\MailingStats;

use Comitium5\CommonWidgetsBundle\MailingStats\StatsManager;
use Comitium5\CommonWidgetsBundle\MailingStats\StatsUtils;
use Comitium5\CommonWidgetsBundle\Tests\TestCase;

class StatsManagerTest extends TestCase
{
    /**
     * phpunit Tests/MailingStats/StatsManagerTest.php
     */
    public function testGenerateKey()
    {
        $email    = "foo@bar.com";
        $emailMd5 = StatsUtils::encodeString($email);
        $expected = "cs_mailing_stats_click_FOO_{$emailMd5}_1234";

        $key = StatsManager::generateKey("click", "FOO", $email, "1234");

        $this->assertEquals($key, $expected);
    }

    /**
     * phpunit Tests/MailingStats/StatsManagerTest.php
     */
    public function testParseData()
    {
        $data = [
            "_r"   => "http://foo.bar.com",
            "_e"   => "foo@bar.com",
            "_cid" => 1,
            "_ext" => [
                "foo" => "bar",
            ]
        ];

        $expected = [
            "campaignId" => 1,
            "email" => "foo@bar.com",
            "extraData" => [
                "foo" => "bar"
            ]
        ];

        $parseData = StatsManager::parseData($data);

        $this->assertEquals($expected, $parseData);
    }

    /**
     * @expectedException \Exception
     * phpunit Tests/MailingStats/StatsManagerTest.php
     */
    public function testParseDataException()
    {
        $data = [
            "foo" => "bar"
        ];

        StatsManager::parseData($data);
    }
}