<?php

namespace Comitium5\CommonWidgetsBundle\Services\Mailer;

use Comitium5\CommonWidgetsBundle\ValueObject\Mailer\SwiftMailer;

/**
 * Class MailerService
 * @package Comitium5\CommonWidgetsBundle\Services
 */
class SwiftMailerService
{
    /**
     * @var SwiftMailer
     */
    protected $mailerValueObject;

    /**
     * SwiftMailerService constructor.
     * @param SwiftMailer $mailerValueObject
     */
    public function __construct(SwiftMailer $mailerValueObject)
    {
        $this->mailerValueObject = $mailerValueObject;
    }

    /**
     * @param $content
     * @return int
     */
    public function sendMail($content) {
        $message = $this->createMessageInstance($content);

        return $this->send($message);
    }

    /**
     * @param $content
     * @return $this
     */
    protected function createMessageInstance($content)
    {
        $message = \Swift_Message::newInstance();

        $message
            ->setSubject($this->mailerValueObject->getSubject())
            ->setTo($this->mailerValueObject->getTo())
            ->setFrom($this->mailerValueObject->getFrom(), $this->mailerValueObject->getFromName())
            ->setBody($content, 'text/html')
            ->setBcc($this->mailerValueObject->getBcc())
        ;

        return $message;
    }

    /**
     * @param \Swift_Message $message
     * @return int
     */
    protected function send(\Swift_Message $message)
    {
        return $this
            ->mailerValueObject
            ->getMailer()
            ->send($message);
    }
}