<?php

namespace Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;

/**
 * Class AbstractWidgetControllerBase
 *
 * @author Óscar Jimenez <oscar@bab-soft.com>
 * @package Controller
 */
abstract class AbstractWidgetControllerBase extends Controller
{
    const SITE_INDEX = "_site";

    const SUBSITE_INDEX = "_subsite";

    const LOCALE_INDEX = "_locale";

    /**
     * @var array
     */
    protected static $parameters = [];

    /**
     * @return array
     */
    protected static function getSite()
    {
        return isset(static::$parameters[self::SITE_INDEX]) ? static::$parameters[self::SITE_INDEX] : [];
    }

    /**
     * @return array
     */
    protected static function getSubsite()
    {
        return isset(static::$parameters[self::SUBSITE_INDEX]) ? static::$parameters[self::SUBSITE_INDEX] : [];
    }

    /**
     * @return mixed
     */
    protected static function getLocale()
    {
        if (isset(static::$parameters[self::LOCALE_INDEX])) {
            return static::$parameters[self::LOCALE_INDEX];
        }

        return null;
    }
}