<?php

namespace Comitium5\CommonWidgetsBundle\Search;

use Elastica\Query;
use Elastica\Index;
use Elastica\Client;
use Elastica\ResultSet;
use Elastica\Search;

/**
 * Class ElasticSearchMinimalProvider
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\Search
 */
class ElasticSearchMinimalProvider
{
    /**
     * @var Index
     */
    private $defaultIndex;

    /**
     * @var Client
     */
    private $client;

    /**
     * ElasticSearchClient constructor.
     * @param $host
     * @param $port
     * @param $index
     */
    public function __construct(
        $host,
        $port,
        $index
    ) {
        $this->client = new Client([
            "host" => $host,
            "port" => $port,
        ]);

        $this->defaultIndex = $index;
    }

    /**
     * @param Query $query
     * @param array $queryOptions
     * @param null $index
     * @param null $type
     * @param bool $parseResults
     * @return array|ResultSet
     */
    public function search(
        Query $query,
        $queryOptions = [],
        $index = null,
        $type = null,
        $parseResults = true
    ) {
        $search = new Search($this->client);

        $search->addIndex($index ? : $this->defaultIndex);

        if ($type !== null) {
            if (is_array($type)) {
                foreach ($type as $typeValue) {
                    $search->addType($typeValue);
                }
            } elseif (is_string($type)) {
                $search->addType($type);
            }
        }

        $results = $search->search($query, $queryOptions);

        return $parseResults === true ?
            ElasticResultParser::parser($results) :
            $results
            ;
    }
}