<?php

namespace Comitium5\CommonWidgetsBundle\Utils\Assets;

/**
 * Class AssetsUtils
 *
 * @author Oscar Jimenez <oscarjg19.developer@gmail.com>
 * @package Comitium5\CommonWidgetsBundle\Utils\Assets
 */
class AssetsUtils
{
    /**
     * @var string
     */
    private $assetPrefix;

    /**
     * @param $assetPrefix
     */
    public function __construct($assetPrefix)
    {
        $this->assetPrefix = $assetPrefix;
    }

    /**
     * @param $url
     *
     * @return string
     */
    public function buildAssetUrl($url)
    {
        return $this->assetPrefix.DIRECTORY_SEPARATOR.$url;
    }

    /**
     * @param array $asset
     * @param array $matchCrops
     * @return string
     */
    public static function generateProSrcSet(array $asset, array $matchCrops = [])
    {
        $data = [];
        $matchWidths = [];
        $matchHeights = [];
        $usedValues = [];
        $children = !empty($asset["children"]) ? $asset["children"] : [];

        if (!empty($matchCrops)) {
            foreach ($matchCrops as $matchCrop) {
                $auxCrops = explode(',', $matchCrop);

                if (!empty($auxCrops)) {
                    foreach( $auxCrops as $auxCrop) {
                        $arr = explode("|", $auxCrop);

                        if (!empty($arr)) {
                            list($width,$height) = $arr;
                            $matchWidths[] = $width;
                            $matchHeights[] = $height;
                        }
                    }

                    rsort($matchWidths, SORT_NUMERIC);
                    rsort($matchHeights, SORT_NUMERIC);
                }
            }
        }

        foreach ($children as $child) {

            $width  = isset($child["metadata"]["width"])  ? $child["metadata"]["width"]  : 0;
            $height = isset($child["metadata"]["height"]) ? $child["metadata"]["height"] : 0;

            $value = sprintf("%s|%s", $width, $height);

            if (in_array($value, $usedValues )) {
                continue;
            }

            if (!empty($matchCrops)) {

                if ($width > $height) {
                    $key = array_search($width, $matchWidths);
                    if ($key === false || $matchHeights[$key] != $height) {
                        continue;
                    }
                } else {
                    $key = array_search($height, $matchHeights);
                    if ($key === false || $matchWidths[$key] != $width) {
                        continue;
                    }
                }

                $data[$key] = sprintf('%s:%s', $value, str_replace('http:', '', $child['url']));

            } else {
                $data[] = sprintf('%s:%s', $value, str_replace('http:', '', $child['url']));
            }

            $usedValues [] = $value;

            ksort($data, SORT_NUMERIC);
        }

        return count($data) ? implode(",", $data) : "";
    }

    /**
     * @param $url
     * @return string
     */
    public static function getMimeType($url, $timeout = 2) {
        try {
            if (empty($url)) {
                return "";
            }

            $context = stream_context_create(['http'=> [
                    'timeout' => $timeout,
                ]
            ]);

            $buffer = file_get_contents($url, false, $context);
            $fInfo  = new \finfo(FILEINFO_MIME_TYPE);

            return $fInfo->buffer($buffer);
        } catch (\Exception $e) {
            return "";
        }
    }
}
